/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Objects;

public final class ETag {
    private static final ClientLogger LOGGER = new ClientLogger(ETag.class);
    static final String WEAK_ETAG_PREFIX_QUOTE = "W/\"";
    static final String ASTERISK = "*";
    public static final ETag ALL = new ETag("*");
    private static final ETag NULL = new ETag(null);
    private final String eTag;

    private ETag(String eTag) {
        this.eTag = eTag;
    }

    public static ETag fromString(String eTag) {
        if (eTag == null) {
            return NULL;
        }
        if (ASTERISK.equals(eTag)) {
            return ALL;
        }
        boolean endsWithQuote = eTag.charAt(eTag.length() - 1) == '\"';
        boolean startsWithQuote = eTag.charAt(0) == '\"';
        boolean startsWithWeakETagPrefix = eTag.startsWith(WEAK_ETAG_PREFIX_QUOTE);
        if (!endsWithQuote || !startsWithQuote && !startsWithWeakETagPrefix) {
            throw LOGGER.atError().addKeyValue("ETag", eTag).log(new IllegalArgumentException("The ETag should be null, '*', be wrapped in quotes, or be wrapped in quotes prefixed by W/"));
        }
        return new ETag(eTag);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ETag)) {
            return false;
        }
        return Objects.equals(this.eTag, ((ETag)o).eTag);
    }

    public int hashCode() {
        return Objects.hashCode(this.eTag);
    }

    public String toString() {
        return this.eTag;
    }

    private void checkValidETag(String eTag) {
    }
}

