/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.credentials;

import io.clientcore.core.credentials.NamedKey;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Objects;

public final class NamedKeyCredential {
    private static final ClientLogger LOGGER = new ClientLogger(NamedKeyCredential.class);
    private volatile NamedKey credentials;

    public NamedKeyCredential(String name, String key) {
        this.validateInputParameters(name, key);
        this.credentials = new NamedKey(name, key);
    }

    public NamedKey getNamedKey() {
        return this.credentials;
    }

    public NamedKeyCredential update(String name, String key) {
        this.validateInputParameters(name, key);
        this.credentials = new NamedKey(name, key);
        return this;
    }

    private void validateInputParameters(String name, String key) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (name.isEmpty()) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        if (key.isEmpty()) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'key' cannot be empty."));
        }
    }
}

