/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.models.binarydata.ByteArrayBinaryData;
import io.clientcore.core.models.binarydata.SerializableBinaryData;
import io.clientcore.core.models.binarydata.StringBinaryData;
import java.net.http.HttpRequest;
import java.time.Duration;

final class BodyPublisherUtils {
    private BodyPublisherUtils() {
    }

    static HttpRequest.BodyPublisher toBodyPublisher(HttpRequest request, Duration writeTimeout) {
        BinaryData body = request.getBody();
        if (body == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        if (body instanceof ByteArrayBinaryData || body instanceof StringBinaryData || body instanceof SerializableBinaryData) {
            byte[] bytes = body.toBytes();
            return BodyPublisherUtils.toBodyPublisherWithLength(HttpRequest.BodyPublishers.ofByteArray(bytes), request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        }
        return BodyPublisherUtils.toBodyPublisherWithLength(HttpRequest.BodyPublishers.ofInputStream(body::toStream), request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
    }

    private static HttpRequest.BodyPublisher toBodyPublisherWithLength(HttpRequest.BodyPublisher publisher, String contentLength) {
        if (contentLength == null || contentLength.isEmpty()) {
            return publisher;
        }
        long contentLengthLong = Long.parseLong(contentLength);
        if (contentLengthLong < 1L) {
            return HttpRequest.BodyPublishers.noBody();
        }
        return HttpRequest.BodyPublishers.fromPublisher(publisher, contentLengthLong);
    }
}

