/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.in;

import io.clientcore.core.serialization.xml.implementation.aalto.in.NsBinding;
import java.util.Objects;
import javax.xml.namespace.QName;

public final class PNameC {
    private final String _prefixedName;
    private final String _prefix;
    private final String _localName;
    private NsBinding _namespaceBinding = null;
    private final int mHash;

    public PNameC(String pname, String prefix, String ln, int hash) {
        this._prefixedName = pname;
        this._prefix = prefix;
        this._localName = ln;
        this.mHash = hash;
    }

    public PNameC createBoundName(NsBinding nsb) {
        PNameC newName = new PNameC(this._prefixedName, this._prefix, this._localName, this.mHash);
        newName._namespaceBinding = nsb;
        return newName;
    }

    public static PNameC construct(String pname) {
        return PNameC.construct(pname, PNameC.calcHash(pname));
    }

    public static PNameC construct(String pname, int hash) {
        int colonIx = pname.indexOf(58);
        if (colonIx < 0) {
            return new PNameC(pname, null, pname, hash);
        }
        return new PNameC(pname, pname.substring(0, colonIx), pname.substring(colonIx + 1), hash);
    }

    public String getPrefixedName() {
        return this._prefixedName;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNsUri() {
        return this._namespaceBinding == null ? null : this._namespaceBinding.mURI;
    }

    public QName constructQName() {
        String pr = this._prefix;
        String uri = this._namespaceBinding == null ? null : this._namespaceBinding.mURI;
        return new QName(uri == null ? "" : uri, this._localName, pr == null ? "" : pr);
    }

    public QName constructQName(NsBinding defaultNs) {
        String uri;
        String pr = this._prefix;
        if (pr == null) {
            pr = "";
        }
        if (this._namespaceBinding != null && (uri = this._namespaceBinding.mURI) != null) {
            return new QName(uri, this._localName, pr);
        }
        uri = defaultNs.mURI;
        return new QName(uri == null ? "" : uri, this._localName, pr);
    }

    public boolean isBound() {
        return this._namespaceBinding == null || this._namespaceBinding.mURI != null;
    }

    public boolean boundEquals(PNameC other) {
        if (other == null || !Objects.equals(other._localName, this._localName)) {
            return false;
        }
        return Objects.equals(other.getNsUri(), this.getNsUri());
    }

    public boolean unboundEquals(PNameC other) {
        return Objects.equals(other._prefixedName, this._prefixedName);
    }

    public boolean boundEquals(String nsUri, String ln) {
        if (!this._localName.equals(ln)) {
            return false;
        }
        String thisUri = this.getNsUri();
        if (nsUri == null || nsUri.isEmpty()) {
            return thisUri == null;
        }
        return nsUri.equals(thisUri);
    }

    public int unboundHashCode() {
        return this._prefixedName.hashCode();
    }

    public int boundHashCode() {
        return this._localName.hashCode();
    }

    public static int boundHashCode(String localName) {
        return localName.hashCode();
    }

    public boolean equalsPName(char[] buffer, int start, int len, int hash) {
        if (hash != this.mHash) {
            return false;
        }
        String pname = this._prefixedName;
        int plen = pname.length();
        if (len != plen) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[start + i] == pname.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int getCustomHash() {
        return this.mHash;
    }

    public static int calcHash(String key) {
        int hash = key.charAt(0);
        int len = key.length();
        for (int i = 1; i < len; ++i) {
            hash = hash * 31 + key.charAt(i);
        }
        return hash;
    }

    public String toString() {
        return this._prefixedName;
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PNameC)) {
            return false;
        }
        PNameC other = (PNameC)o;
        return Objects.equals(other._prefix, this._prefix) && Objects.equals(other._localName, this._localName);
    }
}

