/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml;

import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.serialization.xml.XmlReader;
import io.clientcore.core.serialization.xml.XmlSerializable;
import io.clientcore.core.serialization.xml.XmlWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.xml.stream.XMLStreamException;

public class XmlSerializer
implements ObjectSerializer {
    private static final ClientLogger LOGGER = new ClientLogger(XmlSerializer.class);
    private static final XmlSerializer INSTANCE = new XmlSerializer();

    public static XmlSerializer getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserializeFromBytes(byte[] bytes, Type type) throws IOException {
        try (XmlReader xmlReader = XmlReader.fromBytes(bytes);){
            T t = XmlSerializer.deserializeShared(xmlReader, type);
            return t;
        }
        catch (XMLStreamException ex) {
            throw LOGGER.throwableAtError().log(ex, IOException::new);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserializeFromStream(InputStream stream, Type type) throws IOException {
        try (XmlReader xmlReader = XmlReader.fromStream(stream);){
            T t = XmlSerializer.deserializeShared(xmlReader, type);
            return t;
        }
        catch (XMLStreamException ex) {
            throw LOGGER.throwableAtError().log(ex, IOException::new);
        }
    }

    private static <T> T deserializeShared(XmlReader xmlReader, Type type) {
        try {
            if (XmlSerializable.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                Class clazz = (Class)type;
                return (T)clazz.getMethod("fromXml", XmlReader.class).invoke(null, xmlReader);
            }
            throw LOGGER.throwableAtError().log("XmlSerializer does not have support for untyped deserialization.", UnsupportedOperationException::new);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw LOGGER.throwableAtError().log(e, RuntimeException::new);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serializeToBytes(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            block14: {
                XmlWriter xmlWriter = XmlWriter.toStream(byteArrayOutputStream);
                try {
                    XmlSerializer.serializeShared(xmlWriter, value);
                    byArray = byteArrayOutputStream.toByteArray();
                    if (xmlWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return byArray;
        }
        catch (XMLStreamException ex) {
            throw LOGGER.throwableAtError().log(ex, IOException::new);
        }
    }

    @Override
    public void serializeToStream(OutputStream stream, Object value) throws IOException {
        if (value == null) {
            return;
        }
        try (XmlWriter xmlWriter = XmlWriter.toStream(stream);){
            XmlSerializer.serializeShared(xmlWriter, value);
        }
        catch (XMLStreamException ex) {
            throw LOGGER.throwableAtError().log(ex, IOException::new);
        }
    }

    private static void serializeShared(XmlWriter xmlWriter, Object value) {
        try {
            if (!(value instanceof XmlSerializable)) {
                throw LOGGER.throwableAtError().log("XmlSerializer does not have support for untyped serialization.", UnsupportedOperationException::new);
            }
            xmlWriter.writeStartDocument();
            ((XmlSerializable)value).toXml(xmlWriter).flush();
        }
        catch (XMLStreamException e) {
            throw LOGGER.throwableAtError().log(e, RuntimeException::new);
        }
    }

    @Override
    public final boolean supportsFormat(SerializationFormat format) {
        return format == SerializationFormat.XML;
    }
}

