/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class StreamUtil {
    private static final ClientLogger LOGGER = new ClientLogger(StreamUtil.class);

    private StreamUtil() {
    }

    public static List<ByteBuffer> readStreamToListOfByteBuffers(InputStream inputStream, Long lengthHint, int initialBufferSize, int maxBufferSize) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "'inputStream' must not be null");
        if (initialBufferSize <= 0) {
            throw LOGGER.throwableAtError().log("'initialBufferSize' must be positive integer", IllegalArgumentException::new);
        }
        if (maxBufferSize < initialBufferSize) {
            throw LOGGER.throwableAtError().log("'maxBufferSize' must not be smaller than 'maxBufferSize'", IllegalArgumentException::new);
        }
        if (lengthHint != null && lengthHint < 0L) {
            throw LOGGER.throwableAtError().log("'length' must not be negative", IllegalArgumentException::new);
        }
        int chunkSize = initialBufferSize;
        if (lengthHint != null) {
            chunkSize = (int)Math.max(4096L, Math.min((long)maxBufferSize, lengthHint));
        }
        long totalRead = 0L;
        long actualLength = lengthHint != null ? lengthHint : Long.MAX_VALUE;
        ReadableByteChannel channel = Channels.newChannel(inputStream);
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        ByteBuffer chunk = ByteBuffer.allocate(chunkSize);
        do {
            if ((read = channel.read(chunk)) >= 0) {
                totalRead += (long)read;
                if (chunk.hasRemaining()) continue;
                int nextChunkSizeCandidate = 2 * chunkSize;
                if ((long)nextChunkSizeCandidate <= actualLength - totalRead && nextChunkSizeCandidate <= maxBufferSize) {
                    chunkSize = nextChunkSizeCandidate;
                }
                chunk.flip();
                buffers.add(chunk);
                if (totalRead == actualLength) {
                    ByteBuffer eofCheckBuffer = ByteBuffer.allocate(1);
                    read = channel.read(eofCheckBuffer);
                    if (read != -1) {
                        chunk = ByteBuffer.allocate(chunkSize);
                        eofCheckBuffer.flip();
                        chunk.put(eofCheckBuffer);
                        continue;
                    }
                    chunk = null;
                    continue;
                }
                chunk = ByteBuffer.allocate(chunkSize);
                continue;
            }
            chunk.flip();
            if (!chunk.hasRemaining()) continue;
            buffers.add(chunk);
        } while (read >= 0);
        return Collections.unmodifiableList(buffers);
    }
}

