/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class SliceInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(SliceInputStream.class);
    private final InputStream innerStream;
    private final long startOfSlice;
    private final long endOfSlice;
    private long innerPosition = 0L;
    private long mark = -1L;

    public SliceInputStream(InputStream inputStream, long position, long count) {
        this.innerStream = Objects.requireNonNull(inputStream, "'inputStream' cannot be null");
        if (position < 0L) {
            throw LOGGER.throwableAtError().log("'position' cannot be negative", IllegalArgumentException::new);
        }
        if (count < 0L) {
            throw LOGGER.throwableAtError().log("'count' cannot be negative", IllegalArgumentException::new);
        }
        this.startOfSlice = position;
        this.endOfSlice = position + count;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.ensureInWindow() < 0L) {
            return 0L;
        }
        if (this.innerPosition > this.endOfSlice) {
            return 0L;
        }
        long toSkip = Math.min(n, Math.max(0L, this.endOfSlice - this.innerPosition));
        long skipped = this.innerStream.skip(toSkip);
        this.innerPosition += skipped;
        return skipped;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.ensureInWindow() < 0L) {
            return -1;
        }
        int nextByte = this.innerStream.read();
        if (nextByte >= 0) {
            ++this.innerPosition;
        }
        return nextByte;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.ensureInWindow() < 0L) {
            return -1;
        }
        int read = this.innerStream.read(b, off, len);
        if (read > 0) {
            this.innerPosition += (long)read;
            if (this.innerPosition > this.endOfSlice) {
                return (int)((long)read - (this.innerPosition - this.endOfSlice));
            }
        }
        return read;
    }

    private long ensureInWindow() throws IOException {
        if (this.startOfSlice == this.endOfSlice) {
            return -1L;
        }
        if (this.innerPosition >= this.endOfSlice) {
            return -1L;
        }
        long totalSkipped = 0L;
        while (this.innerPosition < this.startOfSlice) {
            long skipped = this.innerStream.skip(this.startOfSlice - this.innerPosition);
            totalSkipped += skipped;
            this.innerPosition += skipped;
            if (skipped != 0L) continue;
            int nextByte = this.innerStream.read();
            if (nextByte < 0) {
                return -1L;
            }
            ++totalSkipped;
            ++this.innerPosition;
        }
        return totalSkipped;
    }

    @Override
    public void close() throws IOException {
        this.innerStream.close();
    }

    @Override
    public boolean markSupported() {
        return this.innerStream.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.ensureInWindow();
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
        this.innerStream.mark(readlimit);
        this.mark = this.innerPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.innerStream.reset();
        this.innerPosition = this.mark;
    }
}

