/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.metrics;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributes;
import io.clientcore.core.implementation.instrumentation.otel.OTelContext;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.metrics.LongCounter;
import java.util.Objects;

final class OTelLongCounter
implements LongCounter {
    private static final LongCounter NOOP = new OTelLongCounter(null);
    private static final ClientLogger LOGGER = new ClientLogger(OTelLongCounter.class);
    private static final FallbackInvoker ADD_INVOKER;
    private static final FallbackInvoker LONG_COUNTER_BUILDER_INVOKER;
    private static final FallbackInvoker SET_DESCRIPTION_INVOKER;
    private static final FallbackInvoker SET_UNIT_INVOKER;
    private static final FallbackInvoker BUILD_INVOKER;
    private final Object otelCounter;

    private OTelLongCounter(Object otelCounter) {
        this.otelCounter = otelCounter;
    }

    public static LongCounter create(Object otelMeter, String name, String description, String unit) {
        if (otelMeter == null || !OTelInitializer.isInitialized()) {
            return NOOP;
        }
        Object counterBuilder = LONG_COUNTER_BUILDER_INVOKER.invoke(otelMeter, name);
        SET_DESCRIPTION_INVOKER.invoke(counterBuilder, description);
        if (!Objects.isNull(unit)) {
            SET_UNIT_INVOKER.invoke(counterBuilder, unit);
        }
        return new OTelLongCounter(BUILD_INVOKER.invoke(counterBuilder));
    }

    @Override
    public void add(long value, InstrumentationAttributes attributes, InstrumentationContext context) {
        Objects.requireNonNull(attributes, "'attributes' cannot be null.");
        if (this.isEnabled() && attributes instanceof OTelAttributes) {
            ADD_INVOKER.invoke(this.otelCounter, value, ((OTelAttributes)attributes).getOTelAttributes(), OTelContext.fromInstrumentationContext(context));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.otelCounter != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker addInvoker = null;
        ReflectiveInvoker longCounterBuilderInvoker = null;
        ReflectiveInvoker setDescriptionInvoker = null;
        ReflectiveInvoker setUnitInvoker = null;
        ReflectiveInvoker buildInvoker = null;
        if (OTelInitializer.isInitialized()) {
            try {
                longCounterBuilderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.METER_CLASS, OTelInitializer.METER_CLASS.getMethod("counterBuilder", String.class));
                setDescriptionInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.LONG_COUNTER_BUILDER_CLASS, OTelInitializer.LONG_COUNTER_BUILDER_CLASS.getMethod("setDescription", String.class));
                setUnitInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.LONG_COUNTER_BUILDER_CLASS, OTelInitializer.LONG_COUNTER_BUILDER_CLASS.getMethod("setUnit", String.class));
                buildInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.LONG_COUNTER_BUILDER_CLASS, OTelInitializer.LONG_COUNTER_BUILDER_CLASS.getMethod("build", new Class[0]));
                addInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.LONG_COUNTER_CLASS, OTelInitializer.LONG_COUNTER_CLASS.getMethod("add", Long.TYPE, OTelInitializer.ATTRIBUTES_CLASS, OTelInitializer.CONTEXT_CLASS));
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        LONG_COUNTER_BUILDER_INVOKER = new FallbackInvoker(longCounterBuilderInvoker, LOGGER);
        SET_DESCRIPTION_INVOKER = new FallbackInvoker(setDescriptionInvoker, LOGGER);
        SET_UNIT_INVOKER = new FallbackInvoker(setUnitInvoker, LOGGER);
        BUILD_INVOKER = new FallbackInvoker(buildInvoker, LOGGER);
        ADD_INVOKER = new FallbackInvoker(addInvoker, LOGGER);
    }
}

