/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.rest;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.HttpResponseException;
import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.implementation.ReflectionSerializable;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.implementation.http.UnexpectedExceptionInformation;
import io.clientcore.core.implementation.http.rest.LengthValidatingInputStream;
import io.clientcore.core.implementation.http.rest.RequestDataConfiguration;
import io.clientcore.core.implementation.http.rest.SwaggerInterfaceParser;
import io.clientcore.core.implementation.http.rest.SwaggerMethodParser;
import io.clientcore.core.implementation.http.serializer.CompositeSerializer;
import io.clientcore.core.implementation.http.serializer.HttpResponseBodyDecoder;
import io.clientcore.core.implementation.http.serializer.MalformedValueException;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.models.binarydata.InputStreamBinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.Base64Uri;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class RestProxyImpl {
    static final ClientLogger LOGGER = new ClientLogger(RestProxyImpl.class);
    final HttpPipeline httpPipeline;
    final CompositeSerializer serializer;
    final SwaggerInterfaceParser interfaceParser;

    public RestProxyImpl(HttpPipeline httpPipeline, SwaggerInterfaceParser interfaceParser, ObjectSerializer ... serializers) {
        this.httpPipeline = httpPipeline;
        this.interfaceParser = interfaceParser;
        this.serializer = new CompositeSerializer(Arrays.asList(serializers));
    }

    public final Object invoke(Object proxy, RequestContext options, SwaggerMethodParser methodParser, Object[] args) {
        try {
            HttpRequest request = RestProxyImpl.createHttpRequest(methodParser, this.serializer, args).setContext(options).setServerSentEventListener(methodParser.setServerSentEventListener(args));
            if (request.getContext() != null) {
                request.getContext().getRequestCallback().accept(request);
            }
            if (request.getBody() != null) {
                request.setBody(RestProxyImpl.validateLength(request));
            }
            Response<BinaryData> response = this.httpPipeline.send(request);
            return RestProxyImpl.handleRestReturnType(response, methodParser, methodParser.getReturnType(), this.serializer);
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
        catch (URISyntaxException e) {
            throw LOGGER.throwableAtError().log(e, (msg, cause) -> CoreException.from(msg, cause, false));
        }
    }

    public static BinaryData validateLength(HttpRequest request) {
        BinaryData binaryData = request.getBody();
        if (binaryData == null) {
            return null;
        }
        long expectedLength = Long.parseLong(request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        if (binaryData instanceof InputStreamBinaryData) {
            InputStream inputStream = binaryData.toStream();
            LengthValidatingInputStream lengthValidatingInputStream = new LengthValidatingInputStream(inputStream, expectedLength);
            return BinaryData.fromStream(lengthValidatingInputStream, expectedLength);
        }
        if (binaryData.getLength() == null) {
            byte[] b = binaryData.toBytes();
            RestProxyImpl.validateLengthInternal(b.length, expectedLength);
            return BinaryData.fromBytes(b);
        }
        RestProxyImpl.validateLengthInternal(binaryData.getLength(), expectedLength);
        return binaryData;
    }

    private static void validateLengthInternal(long length, long expectedLength) {
        if (length > expectedLength) {
            throw LOGGER.throwableAtError().addKeyValue("actualLength", length).addKeyValue("expectedLength", expectedLength).log("Request body emitted more than the expected stream length.", IllegalStateException::new);
        }
        if (length < expectedLength) {
            throw LOGGER.throwableAtError().addKeyValue("actualLength", length).addKeyValue("expectedLength", expectedLength).log("Request body emitted less than the expected stream length.", IllegalStateException::new);
        }
    }

    private static HttpRequest createHttpRequest(SwaggerMethodParser methodParser, CompositeSerializer serializer, Object[] args) throws IOException, URISyntaxException {
        UriBuilder uriBuilder;
        String path = methodParser.setPath(args, serializer);
        UriBuilder pathUriBuilder = UriBuilder.parse(path);
        if (pathUriBuilder.getScheme() != null) {
            uriBuilder = pathUriBuilder;
        } else {
            uriBuilder = new UriBuilder();
            methodParser.setSchemeAndHost(args, uriBuilder, serializer);
            if (path != null && !path.isEmpty() && !"/".equals(path)) {
                String hostPath = uriBuilder.getPath();
                if (hostPath == null || hostPath.isEmpty() || "/".equals(hostPath) || path.contains("://")) {
                    uriBuilder.setPath(path);
                } else if (path.startsWith("/")) {
                    uriBuilder.setPath(hostPath + path);
                } else {
                    uriBuilder.setPath(hostPath + "/" + path);
                }
            }
        }
        methodParser.setEncodedQueryParameters(args, uriBuilder, serializer);
        URI uri = uriBuilder.toUri();
        HttpRequest request = RestProxyImpl.configRequest(new HttpRequest().setMethod(methodParser.getHttpMethod()).setUri(uri), methodParser, serializer, args);
        HttpHeaders httpHeaders = request.getHeaders();
        methodParser.setHeaders(args, httpHeaders, serializer);
        return request;
    }

    private static HttpRequest configRequest(HttpRequest request, SwaggerMethodParser methodParser, CompositeSerializer serializer, Object[] args) throws IOException {
        Object bodyContentObject = methodParser.setBody(args, serializer);
        if (bodyContentObject == null) {
            request.getHeaders().set(HttpHeaderName.CONTENT_LENGTH, "0");
        } else {
            String[] contentTypeParts;
            String contentType = methodParser.getBodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.getHeaders().set(HttpHeaderName.CONTENT_TYPE, contentType);
            if (bodyContentObject instanceof BinaryData) {
                BinaryData binaryData = (BinaryData)bodyContentObject;
                if (binaryData.getLength() != null) {
                    request.getHeaders().set(HttpHeaderName.CONTENT_LENGTH, binaryData.getLength().toString());
                }
                request.setBody(binaryData);
                return request;
            }
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            RestProxyImpl.updateRequest(new RequestDataConfiguration(request, methodParser, isJson, bodyContentObject), serializer);
        }
        return request;
    }

    private static Response<?> ensureExpectedStatus(Response<BinaryData> response, SwaggerMethodParser methodParser, CompositeSerializer serializer) {
        int responseStatusCode = response.getStatusCode();
        if (methodParser.isExpectedResponseStatusCode(responseStatusCode)) {
            return response;
        }
        if (response.getValue() == null || response.getValue().toBytes().length == 0) {
            throw RestProxyImpl.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), response, null, null);
        }
        throw RestProxyImpl.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), response, response.getValue(), HttpResponseBodyDecoder.decodeByteArray(response.getValue(), response, serializer, methodParser));
    }

    private static HttpResponseException instantiateUnexpectedException(UnexpectedExceptionInformation unexpectedExceptionInformation, Response<BinaryData> response, BinaryData responseBody, Object responseDecodedBody) {
        StringBuilder exceptionMessage = new StringBuilder("Status code ").append(response.getStatusCode()).append(", ");
        String contentType = response.getHeaders().getValue(HttpHeaderName.CONTENT_TYPE);
        if ("application/octet-stream".equalsIgnoreCase(contentType)) {
            String contentLength = response.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH);
            exceptionMessage.append("(").append(contentLength).append("-byte body)");
        } else if (responseBody == null || responseBody.toBytes().length == 0) {
            exceptionMessage.append("(empty body)");
        } else {
            exceptionMessage.append('\"').append(new String(responseBody.toBytes(), StandardCharsets.UTF_8)).append('\"');
        }
        if (responseDecodedBody instanceof IOException || responseDecodedBody instanceof MalformedValueException || responseDecodedBody instanceof IllegalStateException) {
            return new HttpResponseException(exceptionMessage.toString(), response, (Throwable)responseDecodedBody);
        }
        return new HttpResponseException(exceptionMessage.toString(), response, responseDecodedBody);
    }

    private static Object handleRestResponseReturnType(Response<BinaryData> response, SwaggerMethodParser methodParser, Type entityType, CompositeSerializer serializer) {
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Response.class)) {
            Type bodyType = TypeUtil.getRestResponseBodyType(entityType);
            if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                response.close();
                return new Response<Object>(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
            }
            return new Response<Object>(response.getRequest(), response.getStatusCode(), response.getHeaders(), RestProxyImpl.handleResponseBody(response, methodParser, bodyType, response.getValue(), serializer));
        }
        return RestProxyImpl.handleResponseBody(response, methodParser, entityType, response.getValue(), serializer);
    }

    private static Object handleResponseBody(Response<BinaryData> response, SwaggerMethodParser methodParser, Type entityType, BinaryData responseBody, CompositeSerializer serializer) {
        Object result;
        int responseStatusCode = response.getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            result = responseStatusCode / 100 == 2;
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            byte[] responseBodyBytes;
            byte[] byArray = responseBodyBytes = responseBody != null ? responseBody.toBytes() : null;
            if (returnValueWireType == Base64Uri.class) {
                responseBodyBytes = new Base64Uri(responseBodyBytes).decodedBytes();
            }
            result = responseBodyBytes != null ? (responseBodyBytes.length == 0 ? null : responseBodyBytes) : null;
        } else {
            result = TypeUtil.isTypeOrSubTypeOf(entityType, InputStream.class) ? responseBody.toStream() : (TypeUtil.isTypeOrSubTypeOf(entityType, BinaryData.class) ? responseBody : HttpResponseBodyDecoder.decodeByteArray(responseBody, response, serializer, methodParser));
        }
        return result;
    }

    private static Object handleRestReturnType(Response<BinaryData> response, SwaggerMethodParser methodParser, Type returnType, CompositeSerializer serializer) {
        Object result;
        Response<?> expectedResponse = RestProxyImpl.ensureExpectedStatus(response, methodParser, serializer);
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            expectedResponse.close();
            result = null;
        } else {
            result = RestProxyImpl.handleRestResponseReturnType(response, methodParser, returnType, serializer);
        }
        return result;
    }

    private static void updateRequest(RequestDataConfiguration requestDataConfiguration, CompositeSerializer serializer) {
        boolean isJson = requestDataConfiguration.isJson();
        HttpRequest request = requestDataConfiguration.getHttpRequest();
        Object bodyContentObject = requestDataConfiguration.getBodyContent();
        if (bodyContentObject == null) {
            return;
        }
        if (ReflectionSerializable.supportsJsonSerializable(bodyContentObject.getClass())) {
            request.setBody(BinaryData.fromObject(bodyContentObject));
            return;
        }
        if (isJson) {
            request.setBody(BinaryData.fromObject(bodyContentObject, serializer.getSerializerForFormat(SerializationFormat.JSON)));
        } else if (bodyContentObject instanceof byte[]) {
            request.setBody(BinaryData.fromBytes((byte[])bodyContentObject));
        } else if (bodyContentObject instanceof String) {
            request.setBody(BinaryData.fromString((String)bodyContentObject));
        } else if (bodyContentObject instanceof ByteBuffer) {
            if (((ByteBuffer)bodyContentObject).hasArray()) {
                request.setBody(BinaryData.fromBytes(((ByteBuffer)bodyContentObject).array()));
            } else {
                byte[] array = new byte[((ByteBuffer)bodyContentObject).remaining()];
                ((ByteBuffer)bodyContentObject).get(array);
                request.setBody(BinaryData.fromBytes(array));
            }
        } else {
            request.setBody(BinaryData.fromObject(bodyContentObject, serializer.getSerializerForFormat(RestProxyImpl.serializationFormatFromContentType(request.getHeaders()))));
        }
    }

    public static SerializationFormat serializationFormatFromContentType(HttpHeaders headers) {
        if (headers == null) {
            return SerializationFormat.JSON;
        }
        String contentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        if (CoreUtils.isNullOrEmpty(contentType)) {
            return SerializationFormat.JSON;
        }
        int contentTypeEnd = contentType.indexOf(59);
        SerializationFormat encoding = RestProxyImpl.checkForKnownEncoding(contentType = contentTypeEnd == -1 ? contentType : contentType.substring(0, contentTypeEnd));
        if (encoding != null) {
            return encoding;
        }
        int contentTypeTypeSplit = contentType.indexOf(47);
        if (contentTypeTypeSplit == -1) {
            return SerializationFormat.JSON;
        }
        String subtype = contentType.substring(contentTypeTypeSplit + 1);
        int lastIndex = subtype.lastIndexOf(43);
        if (lastIndex == -1) {
            return SerializationFormat.JSON;
        }
        String mimeTypeSuffix = subtype.substring(lastIndex + 1);
        if ("xml".equalsIgnoreCase(mimeTypeSuffix)) {
            return SerializationFormat.XML;
        }
        if ("json".equalsIgnoreCase(mimeTypeSuffix)) {
            return SerializationFormat.JSON;
        }
        return SerializationFormat.JSON;
    }

    private static SerializationFormat checkForKnownEncoding(String contentType) {
        int length = contentType.length();
        if (length != 8 && length != 9 && length != 10 && length != 15 && length != 16) {
            return null;
        }
        if ("text/".regionMatches(true, 0, contentType, 0, 5)) {
            if (length == 8) {
                if ("xml".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.XML;
                }
                if ("csv".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.TEXT;
                }
                if ("css".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.TEXT;
                }
            } else {
                if (length == 9 && "html".regionMatches(true, 0, contentType, 5, 4)) {
                    return SerializationFormat.TEXT;
                }
                if (length == 10 && "plain".regionMatches(true, 0, contentType, 5, 5)) {
                    return SerializationFormat.TEXT;
                }
                if (length == 15 && "javascript".regionMatches(true, 0, contentType, 5, 10)) {
                    return SerializationFormat.TEXT;
                }
            }
        } else if ("application/".regionMatches(true, 0, contentType, 0, 12)) {
            if (length == 16 && "json".regionMatches(true, 0, contentType, 12, 4)) {
                return SerializationFormat.JSON;
            }
            if (length == 15 && "xml".regionMatches(true, 0, contentType, 12, 3)) {
                return SerializationFormat.XML;
            }
        }
        return null;
    }
}

