/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http;

import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.instrumentation.logging.ClientLogger;

public class HttpPipelineCallState {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineCallState.class);
    private final HttpPipeline pipeline;
    private final HttpRequest httpRequest;
    private int currentPolicyIndex;

    public HttpPipelineCallState(HttpPipeline pipeline, HttpRequest httpRequest) {
        this.pipeline = pipeline;
        this.httpRequest = httpRequest;
        this.currentPolicyIndex = -1;
    }

    public HttpPipelinePolicy getNextPolicy() {
        int size = this.pipeline.getPolicies().size();
        ++this.currentPolicyIndex;
        if (this.currentPolicyIndex > size) {
            throw LOGGER.throwableAtError().log("There is no more policies to execute.", IllegalStateException::new);
        }
        if (this.currentPolicyIndex == size) {
            return null;
        }
        return this.pipeline.getPolicies().get(this.currentPolicyIndex);
    }

    public HttpPipeline getPipeline() {
        return this.pipeline;
    }

    public HttpPipelinePolicy getCurrentPolicy() {
        return this.pipeline.getPolicies().get(this.currentPolicyIndex);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpPipelineCallState copy() {
        HttpPipelineCallState copy = new HttpPipelineCallState(this.pipeline, this.httpRequest);
        copy.currentPolicyIndex = this.currentPolicyIndex;
        return copy;
    }
}

