/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.utils.CoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class HttpHeader {
    private final HttpHeaderName name;
    private String value;
    private List<String> values;
    private volatile String cachedStringValue;
    private static final AtomicReferenceFieldUpdater<HttpHeader, String> CACHED_STRING_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(HttpHeader.class, String.class, "cachedStringValue");

    public HttpHeader(HttpHeaderName name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.value = value;
    }

    public HttpHeader(HttpHeaderName name, String ... values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        int length = values.length;
        if (length == 1) {
            this.value = values[0];
        } else if (length != 0) {
            this.values = new ArrayList<String>(Math.max(length + 2, 4));
            Collections.addAll(this.values, values);
        }
    }

    public HttpHeader(HttpHeaderName name, List<String> values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        int size = values.size();
        if (size == 1) {
            this.value = values.get(0);
        } else if (size != 0) {
            this.values = new ArrayList<String>(Math.max(size + 2, 4));
            this.values.addAll(values);
        }
    }

    public HttpHeaderName getName() {
        return this.name;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return CACHED_STRING_VALUE_UPDATER.get(this);
    }

    public List<String> getValues() {
        if (this.value != null) {
            return Collections.singletonList(this.value);
        }
        if (!CoreUtils.isNullOrEmpty(this.values)) {
            return Collections.unmodifiableList(this.values);
        }
        return Collections.emptyList();
    }

    public void addValue(String value) {
        if (this.value == null && this.values == null) {
            this.value = value;
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList<String>(4);
            this.values.add(this.value);
            this.value = null;
        }
        this.values.add(value);
        CACHED_STRING_VALUE_UPDATER.set(this, null);
    }

    public String toString() {
        if (this.value != null) {
            return this.name + ":" + this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return this.name + ":" + CACHED_STRING_VALUE_UPDATER.get(this);
    }

    private void checkCachedStringValue() {
        CACHED_STRING_VALUE_UPDATER.compareAndSet(this, null, CoreUtils.stringJoin(",", this.values));
    }
}

