/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.utils.ExpandableEnum;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class AuthScheme
implements ExpandableEnum<String> {
    private static final Map<String, AuthScheme> VALUES = new ConcurrentHashMap<String, AuthScheme>();
    private final String name;
    public static final AuthScheme OAUTH2 = AuthScheme.fromString("oauth2");
    public static final AuthScheme API_KEY = AuthScheme.fromString("apiKey");
    public static final AuthScheme NO_AUTH = AuthScheme.fromString("noAuth");

    private AuthScheme(String name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.name;
    }

    public static AuthScheme fromString(String name) {
        if (name == null) {
            return null;
        }
        return VALUES.computeIfAbsent(name, AuthScheme::new);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthScheme)) {
            return false;
        }
        AuthScheme other = (AuthScheme)obj;
        return Objects.equals(this.name, other.name);
    }
}

