/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.credentials.oauth;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.CoreUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OAuthTokenRequestContext {
    private static final ClientLogger LOGGER = new ClientLogger(OAuthTokenRequestContext.class);
    private List<String> scopes;
    private Map<String, Object> params;

    public List<String> getScopes() {
        if (CoreUtils.isNullOrEmpty(this.scopes)) {
            return Collections.emptyList();
        }
        return this.scopes;
    }

    public OAuthTokenRequestContext setScopes(List<String> scopes) {
        Objects.requireNonNull(scopes, "'scopes' cannot be null.");
        this.scopes = scopes;
        return this;
    }

    public OAuthTokenRequestContext addScopes(String ... scopes) {
        Objects.requireNonNull(scopes, "'scopes' cannot be null.");
        if (scopes.length == 0) {
            throw LOGGER.throwableAtError().log("At least one scope must be provided.", IllegalArgumentException::new);
        }
        for (String scope : scopes) {
            if (!CoreUtils.isNullOrEmpty(scope)) continue;
            throw LOGGER.throwableAtError().log("Scopes cannot contain null or empty values.", IllegalArgumentException::new);
        }
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public Map<String, Object> getParams() {
        if (CoreUtils.isNullOrEmpty(this.params)) {
            return Collections.emptyMap();
        }
        return this.params;
    }

    public OAuthTokenRequestContext setParams(Map<String, Object> params) {
        Objects.requireNonNull(params, "'params' cannot be null");
        this.params = params;
        return this;
    }

    public OAuthTokenRequestContext setParam(String key, String value) {
        if (CoreUtils.isNullOrEmpty(key)) {
            throw LOGGER.throwableAtError().log("Parameter 'key' cannot be null or empty.", IllegalArgumentException::new);
        }
        if (CoreUtils.isNullOrEmpty(value)) {
            throw LOGGER.throwableAtError().log("Parameter 'value' cannot be null or empty.", IllegalArgumentException::new);
        }
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, value);
        return this;
    }
}

