/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.client;

import io.clientcore.core.http.client.HttpClient;
import io.clientcore.core.http.client.HttpProtocolVersion;
import io.clientcore.core.http.models.ProxyOptions;
import io.clientcore.core.implementation.http.client.JdkHttpClient;
import io.clientcore.core.implementation.http.client.JdkHttpClientProxySelector;
import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.SharedExecutorService;
import io.clientcore.core.utils.configuration.Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdkHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(JdkHttpClientBuilder.class);
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = ImplUtils.getDefaultHttpConnectTimeout();
    private static final Duration DEFAULT_WRITE_TIMEOUT = ImplUtils.getDefaultHttpWriteTimeout();
    private static final Duration DEFAULT_RESPONSE_TIMEOUT = ImplUtils.getDefaultHttpResponseTimeout();
    private static final Duration DEFAULT_READ_TIMEOUT = ImplUtils.getDefaultHttpReadTimeout();
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS = "jdk.httpclient.allowRestrictedHeaders";
    static final Set<String> DEFAULT_RESTRICTED_HEADERS = Set.of("connection", "content-length", "expect", "host", "upgrade");
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Executor executor;
    private SSLContext sslContext;
    private HttpProtocolVersion maximumHttpVersion = HttpProtocolVersion.HTTP_2;
    private Duration connectionTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    public JdkHttpClientBuilder() {
        this.executor = SharedExecutorService.getInstance();
    }

    public JdkHttpClientBuilder executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor can not be null");
        return this;
    }

    public JdkHttpClientBuilder connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public JdkHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public JdkHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public JdkHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public JdkHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        if (proxyOptions != null) {
            Objects.requireNonNull(proxyOptions.getType(), "Proxy type is required.");
            Objects.requireNonNull(proxyOptions.getAddress(), "Proxy address is required.");
        }
        this.proxyOptions = proxyOptions;
        return this;
    }

    public JdkHttpClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public JdkHttpClientBuilder setMaximumHttpVersion(HttpProtocolVersion httpVersion) {
        this.maximumHttpVersion = httpVersion != null ? httpVersion : HttpProtocolVersion.HTTP_2;
        return this;
    }

    public JdkHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClient build() {
        ProxyOptions buildProxyOptions;
        HttpClient.Builder httpClientBuilder = java.net.http.HttpClient.newBuilder();
        httpClientBuilder = httpClientBuilder.connectTimeout(JdkHttpClientBuilder.getTimeout(this.connectionTimeout, DEFAULT_CONNECTION_TIMEOUT));
        Duration writeTimeout = JdkHttpClientBuilder.getTimeout(this.writeTimeout, DEFAULT_WRITE_TIMEOUT);
        Duration responseTimeout = JdkHttpClientBuilder.getTimeout(this.responseTimeout, DEFAULT_RESPONSE_TIMEOUT);
        Duration readTimeout = JdkHttpClientBuilder.getTimeout(this.readTimeout, DEFAULT_READ_TIMEOUT);
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions = buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration(buildConfiguration) : this.proxyOptions;
        if (this.executor != null) {
            httpClientBuilder.executor(this.executor);
        }
        if (this.sslContext != null) {
            httpClientBuilder.sslContext(this.sslContext);
        }
        if (this.maximumHttpVersion == HttpProtocolVersion.HTTP_1_1) {
            httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        } else if (this.maximumHttpVersion == HttpProtocolVersion.HTTP_2) {
            httpClientBuilder.version(HttpClient.Version.HTTP_2);
        }
        if (buildProxyOptions != null) {
            httpClientBuilder = httpClientBuilder.proxy(new JdkHttpClientProxySelector(buildProxyOptions.getType().toProxyType(), buildProxyOptions.getAddress(), buildProxyOptions.getNonProxyHosts()));
            if (buildProxyOptions.getUsername() != null) {
                httpClientBuilder.authenticator(new ProxyAuthenticator(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()));
            }
        }
        return new JdkHttpClient(httpClientBuilder.build(), Collections.unmodifiableSet(this.getRestrictedHeaders()), writeTimeout, responseTimeout, readTimeout);
    }

    Set<String> getRestrictedHeaders() {
        HashSet<String> restrictedHeaders = new HashSet<String>(DEFAULT_RESTRICTED_HEADERS);
        this.removeAllowedHeaders(restrictedHeaders);
        return restrictedHeaders;
    }

    private void removeAllowedHeaders(Set<String> restrictedHeaders) {
        String[] allowRestrictedHeadersSystemProperties;
        Properties properties = this.getNetworkProperties();
        String[] allowRestrictedHeadersNetProperties = properties.getProperty(JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS, "").split(",");
        Configuration config = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        String allowRestrictedHeadersSystemPropertiesConfig = config.get(JDK_HTTPCLIENT_ALLOW_RESTRICTED_HEADERS);
        for (String header : allowRestrictedHeadersSystemProperties = allowRestrictedHeadersSystemPropertiesConfig == null ? new String[]{} : allowRestrictedHeadersSystemPropertiesConfig.split(",")) {
            restrictedHeaders.remove(header.trim().toLowerCase(Locale.ROOT));
        }
        for (String header : allowRestrictedHeadersNetProperties) {
            restrictedHeaders.remove(header.trim().toLowerCase(Locale.ROOT));
        }
    }

    Properties getNetworkProperties() {
        Path path = Paths.get(JAVA_HOME, "conf", "net.properties");
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.atWarning().addKeyValue("path", path).setThrowable(e).log("Cannot read net properties.");
        }
        return properties;
    }

    private static Duration getTimeout(Duration configuredTimeout, Duration defaultTimeout) {
        if (configuredTimeout == null) {
            return defaultTimeout;
        }
        return configuredTimeout.compareTo(MINIMUM_TIMEOUT) < 0 ? MINIMUM_TIMEOUT : configuredTimeout;
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final String userName;
        private final String password;

        ProxyAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

