/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.implementation.utils.QueryParameter;
import io.clientcore.core.implementation.utils.UriToken;
import io.clientcore.core.implementation.utils.UriTokenType;
import io.clientcore.core.implementation.utils.UriTokenizer;
import io.clientcore.core.implementation.utils.UriTokenizerState;
import io.clientcore.core.utils.CoreUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class UriBuilder {
    private static final Map<String, UriBuilder> PARSED_URIS = new ConcurrentHashMap<String, UriBuilder>();
    private static final int MAX_CACHE_SIZE = 10000;
    private String scheme;
    private String host;
    private Integer port;
    private String path;
    private Map<String, QueryParameter> queryToCopy;
    private Map<String, QueryParameter> query;

    public UriBuilder() {
        this(null);
    }

    private UriBuilder(Map<String, QueryParameter> queryToCopy) {
        this.queryToCopy = queryToCopy;
    }

    public UriBuilder setScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            this.scheme = null;
        } else {
            this.with(scheme, UriTokenizerState.SCHEME);
        }
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriBuilder setHost(String host) {
        if (host == null || host.isEmpty()) {
            this.host = null;
        } else {
            this.with(host, UriTokenizerState.SCHEME_OR_HOST);
        }
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UriBuilder setPort(String port) {
        if (CoreUtils.isNullOrEmpty(port)) {
            this.port = null;
            return this;
        }
        return this.with(port, UriTokenizerState.PORT);
    }

    public UriBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public UriBuilder setPath(String path) {
        if (path == null || path.isEmpty()) {
            this.path = null;
        } else {
            this.with(path, UriTokenizerState.PATH);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UriBuilder setQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.initializeQuery();
        this.query.put(queryParameterName, new QueryParameter(queryParameterName, queryParameterEncodedValue));
        return this;
    }

    public UriBuilder addQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.initializeQuery();
        this.query.compute(queryParameterName, (key, value) -> {
            if (value == null) {
                return new QueryParameter(queryParameterName, queryParameterEncodedValue);
            }
            value.addValue(queryParameterEncodedValue);
            return value;
        });
        return this;
    }

    public UriBuilder addQueryParameterValues(String queryParameterName, List<String> queryParameterEncodedValues) {
        this.initializeQuery();
        this.query.compute(queryParameterName, (key, value) -> {
            if (value == null) {
                return new QueryParameter(queryParameterName, queryParameterEncodedValues);
            }
            value.addValues(queryParameterEncodedValues);
            return value;
        });
        return this;
    }

    public UriBuilder setQuery(String query) {
        return query == null || query.isEmpty() ? this.clearQuery() : this.with(query, UriTokenizerState.QUERY);
    }

    public UriBuilder clearQuery() {
        if (CoreUtils.isNullOrEmpty(this.query)) {
            return this;
        }
        this.query.clear();
        return this;
    }

    public Map<String, String> getQuery() {
        this.initializeQuery();
        return this.query.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((QueryParameter)entry.getValue()).getValue()));
    }

    public String getQueryString() {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder();
        this.appendQueryString(queryBuilder);
        return queryBuilder.toString();
    }

    private void appendQueryString(StringBuilder stringBuilder) {
        if (CoreUtils.isNullOrEmpty(this.queryToCopy) && CoreUtils.isNullOrEmpty(this.query)) {
            return;
        }
        stringBuilder.append('?');
        boolean first = true;
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>(this.queryToCopy.size());
            for (Map.Entry<String, QueryParameter> entry : this.queryToCopy.entrySet()) {
                first = UriBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), first);
                this.query.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, QueryParameter> entry : this.query.entrySet()) {
                first = UriBuilder.writeQueryValues(stringBuilder, entry.getKey(), entry.getValue().getValuesList(), first);
            }
        }
    }

    private static boolean writeQueryValues(StringBuilder builder, String key, List<String> values, boolean first) {
        if (CoreUtils.isNullOrEmpty(values)) {
            if (!first) {
                builder.append('&');
            }
            builder.append(key);
            first = false;
        } else {
            for (String value : values) {
                if (!first) {
                    builder.append('&');
                }
                builder.append(key).append('=').append(value);
                first = false;
            }
        }
        return first;
    }

    private UriBuilder with(String text, UriTokenizerState startState) {
        UriTokenizer tokenizer = new UriTokenizer(text, startState);
        while (tokenizer.next()) {
            UriToken token = tokenizer.current();
            String tokenText = UriBuilder.emptyToNull(token.text());
            UriTokenType tokenType = token.type();
            switch (tokenType) {
                case SCHEME: {
                    this.scheme = tokenText;
                    break;
                }
                case HOST: {
                    this.host = tokenText;
                    break;
                }
                case PORT: {
                    this.port = tokenText == null ? null : Integer.valueOf(Integer.parseInt(tokenText));
                    break;
                }
                case PATH: {
                    if (this.path != null && !"/".equals(this.path) && "/".equals(tokenText)) break;
                    this.path = tokenText;
                    break;
                }
                case QUERY: {
                    UriBuilder.parseQueryParameters(tokenText).forEachRemaining(queryParam -> this.addQueryParameter((String)queryParam.getKey(), (String)queryParam.getValue()));
                    break;
                }
            }
        }
        return this;
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        boolean isAbsolutePath;
        StringBuilder result = new StringBuilder();
        boolean bl = isAbsolutePath = this.path != null && (this.path.startsWith("http://") || this.path.startsWith("https://"));
        if (!isAbsolutePath) {
            if (this.scheme != null) {
                result.append(this.scheme);
                if (!this.scheme.endsWith("://")) {
                    result.append("://");
                }
            }
            if (this.host != null) {
                result.append(this.host);
            }
        }
        if (this.port != null) {
            result.append(':');
            result.append(this.port);
        }
        if (this.path != null) {
            if (result.length() != 0 && !this.path.startsWith("/")) {
                result.append('/');
            }
            result.append(this.path);
        }
        this.appendQueryString(result);
        return result.toString();
    }

    static Map<String, UriBuilder> getParsedUris() {
        return PARSED_URIS;
    }

    public static UriBuilder parse(String uri) {
        String concurrentSafeUri;
        String string = concurrentSafeUri = uri == null ? "" : uri;
        if (PARSED_URIS.size() >= 10000) {
            PARSED_URIS.clear();
        }
        return PARSED_URIS.computeIfAbsent(concurrentSafeUri, u -> new UriBuilder().with((String)u, UriTokenizerState.SCHEME_OR_HOST)).copy();
    }

    public static UriBuilder parse(URI uri) {
        return UriBuilder.parse(uri, true);
    }

    public static UriBuilder parse(URI uri, boolean includeQuery) {
        UriBuilder result = new UriBuilder();
        if (uri != null) {
            String query;
            String path;
            int port;
            String host;
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.isEmpty()) {
                result.setScheme(scheme);
            }
            if ((host = uri.getHost()) != null && !host.isEmpty()) {
                result.setHost(host);
            }
            if ((port = uri.getPort()) != -1) {
                result.setPort(port);
            }
            if ((path = uri.getPath()) != null && !path.isEmpty()) {
                result.setPath(path);
            }
            if ((query = uri.getQuery()) != null && !query.isEmpty() && includeQuery) {
                result.setQuery(query);
            }
        }
        return result;
    }

    private static String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private UriBuilder copy() {
        UriBuilder copy = new UriBuilder(this.query);
        copy.scheme = this.scheme;
        copy.host = this.host;
        copy.path = this.path;
        copy.port = this.port;
        return copy;
    }

    private void initializeQuery() {
        if (this.query == null) {
            this.query = new LinkedHashMap<String, QueryParameter>();
        }
        if (this.queryToCopy != null) {
            this.query.putAll(this.queryToCopy);
            this.queryToCopy = null;
        }
    }

    private static Iterator<Map.Entry<String, String>> parseQueryParameters(String queryParameters) {
        return CoreUtils.isNullOrEmpty(queryParameters) ? Collections.emptyIterator() : new ImplUtils.QueryParameterIterator(queryParameters);
    }
}

