/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.CoreUtils;
import java.util.Collections;
import java.util.Map;

public final class AuthenticateChallenge {
    private static final ClientLogger LOGGER = new ClientLogger(AuthenticateChallenge.class);
    private final String scheme;
    private final Map<String, String> parameters;
    private final String token68;

    public AuthenticateChallenge(String scheme) {
        this(scheme, Collections.emptyMap(), null);
    }

    public AuthenticateChallenge(String scheme, String token68) {
        this(scheme, Collections.emptyMap(), token68);
    }

    public AuthenticateChallenge(String scheme, Map<String, String> parameters) {
        this(scheme, parameters, null);
    }

    AuthenticateChallenge(String scheme, Map<String, String> parameters, String token68) {
        if (CoreUtils.isNullOrEmpty(scheme)) {
            throw LOGGER.throwableAtError().log("scheme cannot be null or empty.", IllegalArgumentException::new);
        }
        this.scheme = scheme;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.token68 = token68;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getToken68() {
        return this.token68;
    }
}

