/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.in;

import io.clientcore.core.serialization.xml.implementation.aalto.impl.CommonConfig;
import io.clientcore.core.serialization.xml.implementation.aalto.in.CharBasedPNameTable;
import io.clientcore.core.serialization.xml.implementation.aalto.util.UriCanonicalizer;
import java.util.HashMap;
import java.util.Objects;

public final class ReaderConfig
extends CommonConfig {
    public static final int DEFAULT_SMALL_BUFFER_LEN = 60;
    public static final int DEFAULT_CHAR_BUFFER_LEN = 4000;
    public static final int STANDALONE_UNKNOWN = 0;
    public static final int STANDALONE_YES = 1;
    public static final int STANDALONE_NO = 2;
    private static final int F_NS_AWARE = 1;
    private static final int F_COALESCING = 2;
    private static final int F_DTD_AWARE = 4;
    private static final int F_DTD_VALIDATING = 8;
    private static final int F_EXPAND_ENTITIES = 16;
    private static final int F_INTERN_NAMES = 512;
    private static final int F_INTERN_NS_URIS = 1024;
    private static final int F_REPORT_CDATA = 2048;
    private static final int F_PRESERVE_LOCATION = 4096;
    private static final int DEFAULT_FLAGS = 7697;
    private static final HashMap<String, Object> sProperties = new HashMap();
    private final EncodingContext mEncCtxt;
    private final UriCanonicalizer mCanonicalizer;
    private String mXmlDeclVersion = null;
    private String mXmlDeclEncoding = null;
    private int mXmlDeclStandalone = 0;

    private ReaderConfig(EncodingContext encCtxt, int flags, int flagMods, UriCanonicalizer canonicalizer) {
        super(flags, flagMods);
        this.mEncCtxt = encCtxt;
        this._flags = flags;
        this._flagMods = flagMods;
        this.mCanonicalizer = canonicalizer;
    }

    public ReaderConfig() {
        this(new EncodingContext(), 7697, 0, new UriCanonicalizer());
    }

    public void setXmlDeclInfo(int version, String xmlDeclEnc, String standalone) {
        this.mXmlDeclVersion = version == 256 ? "1.0" : (version == 272 ? "1.1" : null);
        this.mXmlDeclEncoding = xmlDeclEnc;
        this.mXmlDeclStandalone = Objects.equals(standalone, "yes") ? 1 : (Objects.equals(standalone, "no") ? 2 : 0);
    }

    public ReaderConfig createNonShared() {
        return new ReaderConfig(this.mEncCtxt, this._flags, this._flagMods, this.mCanonicalizer);
    }

    @Override
    public Object getProperty(String name, boolean isMandatory) {
        Object ob = sProperties.get(name);
        if (ob == null) {
            if (sProperties.containsKey(name)) {
                return null;
            }
            return super.getProperty(name, isMandatory);
        }
        if (ob instanceof Boolean) {
            return ob;
        }
        if (!(ob instanceof Integer)) {
            throw new RuntimeException("Internal error: unrecognized property value type: " + ob.getClass().getName());
        }
        int f = (Integer)ob;
        return this.hasFlag(f);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        Object ob = sProperties.get(name);
        if (ob == null) {
            if (sProperties.containsKey(name)) {
                return false;
            }
            return super.setProperty(name, value);
        }
        if (ob instanceof Boolean) {
            return false;
        }
        if (!(ob instanceof Integer)) {
            throw new RuntimeException("Internal error");
        }
        int f = (Integer)ob;
        boolean state = (Boolean)value;
        this.setFlag(f, state);
        return true;
    }

    @Override
    public boolean isPropertySupported(String propName) {
        return sProperties.containsKey(propName) || super.isPropertySupported(propName);
    }

    public boolean willExpandEntities() {
        return this.hasFlag(16);
    }

    public boolean willCoalesceText() {
        return this.hasFlag(2);
    }

    public String getXmlDeclVersion() {
        return this.mXmlDeclVersion;
    }

    public String getXmlDeclEncoding() {
        return this.mXmlDeclEncoding;
    }

    public int getXmlDeclStandalone() {
        return this.mXmlDeclStandalone;
    }

    public String canonicalizeURI(char[] buf, int uriLen) {
        return this.mCanonicalizer.canonicalizeURI(buf, uriLen);
    }

    public CharBasedPNameTable getCBSymbols() {
        return this.mEncCtxt.getSymbols();
    }

    public void updateCBSymbols(CharBasedPNameTable sym) {
        this.mEncCtxt.updateSymbols(sym);
    }

    static {
        sProperties.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        sProperties.put("javax.xml.stream.isValidating", 8);
        sProperties.put("javax.xml.stream.isCoalescing", 2);
        sProperties.put("javax.xml.stream.isReplacingEntityReferences", 16);
        sProperties.put("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        sProperties.put("javax.xml.stream.supportDTD", 4);
        sProperties.put("javax.xml.stream.reporter", null);
        sProperties.put("javax.xml.stream.resolver", null);
        sProperties.put("javax.xml.stream.allocator", null);
        sProperties.put("io.clientcore.core.serialization.xml.implementation.stax2.internNames", 512);
        sProperties.put("io.clientcore.core.serialization.xml.implementation.stax2.internNsUris", 1024);
        sProperties.put("http://java.sun.com/xml/stream/properties/report-cdata-event", 2048);
        sProperties.put("io.clientcore.core.serialization.xml.implementation.stax2.preserveLocation", Boolean.TRUE);
    }

    static final class EncodingContext {
        CharBasedPNameTable mGeneralTable;

        EncodingContext() {
        }

        public synchronized CharBasedPNameTable getSymbols() {
            if (this.mGeneralTable == null) {
                this.mGeneralTable = new CharBasedPNameTable(64);
            }
            return new CharBasedPNameTable(this.mGeneralTable);
        }

        public synchronized void updateSymbols(CharBasedPNameTable sym) {
            this.mGeneralTable.mergeFromChild(sym);
        }
    }
}

