/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core;

import io.clientcore.core.serialization.json.implementation.jackson.core.JsonGenerator;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonParser;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.ContentReference;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.IOContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.json.ReaderBasedJsonParser;
import io.clientcore.core.serialization.json.implementation.jackson.core.json.WriterBasedJsonGenerator;
import io.clientcore.core.serialization.json.implementation.jackson.core.sym.CharsToNameCanonicalizer;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.BufferRecycler;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.BufferRecyclers;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class JsonFactory
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    public static final char DEFAULT_QUOTE_CHAR = '\"';

    public JsonParser createParser(Reader r) {
        IOContext ctxt = this._createContext(this._createContentReference(r));
        return new ReaderBasedJsonParser(ctxt, DEFAULT_PARSER_FEATURE_FLAGS, r, CharsToNameCanonicalizer.createRoot().makeChild());
    }

    public JsonGenerator createGenerator(Writer w) {
        IOContext ctxt = this._createContext(this._createContentReference(w));
        return new WriterBasedJsonGenerator(ctxt, DEFAULT_GENERATOR_FEATURE_FLAGS, w);
    }

    public BufferRecycler _getBufferRecycler() {
        return BufferRecyclers.getBufferRecycler();
    }

    protected IOContext _createContext(ContentReference contentRef) {
        if (contentRef == null) {
            contentRef = ContentReference.unknown();
        }
        return new IOContext(this._getBufferRecycler(), contentRef);
    }

    protected ContentReference _createContentReference(Object contentAccessor) {
        return ContentReference.construct(contentAccessor);
    }
}

