/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json;

import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.json.JsonOptions;
import io.clientcore.core.serialization.json.JsonSerializable;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriteContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonFactory;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonGenerator;
import io.clientcore.core.utils.IOExceptionCheckedBiConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class JsonWriter
implements Closeable {
    private static final JsonFactory FACTORY = new JsonFactory();
    private final JsonGenerator generator;
    private JsonWriteContext context = JsonWriteContext.ROOT;

    private JsonWriter(JsonGenerator generator, JsonOptions options) {
        this.generator = generator;
        this.generator.configure(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS, true);
    }

    public static JsonWriter toStream(OutputStream json) throws IOException {
        return JsonWriter.toStream(json, null);
    }

    public static JsonWriter toStream(OutputStream json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "'json' cannot be null.");
        return new JsonWriter(FACTORY.createGenerator(new OutputStreamWriter(json)), options);
    }

    public static JsonWriter toWriter(Writer json) throws IOException {
        return JsonWriter.toWriter(json, null);
    }

    public static JsonWriter toWriter(Writer json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "'json' cannot be null.");
        return new JsonWriter(FACTORY.createGenerator(json), options);
    }

    public JsonWriteContext getWriteContext() {
        return this.context;
    }

    @Override
    public void close() throws IOException {
        if (this.context != JsonWriteContext.COMPLETED) {
            throw new IllegalStateException("Writing of the JSON object must be completed before the writer can be closed. Current writing state is '" + (Object)((Object)this.context.getWriteState()) + "'.");
        }
        this.generator.flush();
        this.generator.close();
    }

    public JsonWriter flush() throws IOException {
        this.generator.flush();
        return this;
    }

    public JsonWriter writeStartObject() throws IOException {
        this.context.validateToken(JsonToken.START_OBJECT);
        this.generator.writeStartObject();
        this.context = this.context.updateContext(JsonToken.START_OBJECT);
        return this;
    }

    public JsonWriter writeStartObject(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeStartObject();
    }

    public JsonWriter writeEndObject() throws IOException {
        this.context.validateToken(JsonToken.END_OBJECT);
        this.generator.writeEndObject();
        this.context = this.context.updateContext(JsonToken.END_OBJECT);
        return this;
    }

    public JsonWriter writeStartArray() throws IOException {
        this.context.validateToken(JsonToken.START_ARRAY);
        this.generator.writeStartArray();
        this.context = this.context.updateContext(JsonToken.START_ARRAY);
        return this;
    }

    public JsonWriter writeStartArray(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeStartArray();
    }

    public JsonWriter writeEndArray() throws IOException {
        this.context.validateToken(JsonToken.END_ARRAY);
        this.generator.writeEndArray();
        this.context = this.context.updateContext(JsonToken.END_ARRAY);
        return this;
    }

    public JsonWriter writeFieldName(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        this.context.validateToken(JsonToken.FIELD_NAME);
        this.generator.writeFieldName(fieldName);
        this.context = this.context.updateContext(JsonToken.FIELD_NAME);
        return this;
    }

    public JsonWriter writeJson(JsonSerializable<?> value) throws IOException {
        return value == null ? this : value.toJson(this);
    }

    public <T> JsonWriter writeArray(T[] array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc) throws IOException {
        return this.writeArray(array, elementWriterFunc, false);
    }

    public <T> JsonWriter writeArray(T[] array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc, boolean skipNullElements) throws IOException {
        Objects.requireNonNull(elementWriterFunc, "'elementWriterFunc' cannot be null.");
        if (array == null) {
            return this.writeNull();
        }
        return this.writeArrayInternal(Arrays.asList(array), elementWriterFunc, null, skipNullElements);
    }

    public <T> JsonWriter writeArray(Iterable<T> array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc) throws IOException {
        return this.writeArray(array, elementWriterFunc, false);
    }

    public <T> JsonWriter writeArray(Iterable<T> array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc, boolean skipNullElements) throws IOException {
        Objects.requireNonNull(elementWriterFunc, "'elementWriterFunc' cannot be null.");
        if (array == null) {
            return this.writeNull();
        }
        return this.writeArrayInternal(array, elementWriterFunc, null, skipNullElements);
    }

    private <T> JsonWriter writeArrayInternal(Iterable<T> array, IOExceptionCheckedBiConsumer<JsonWriter, T> func, String fieldName, boolean skipNullElements) throws IOException {
        if (fieldName == null) {
            this.writeStartArray();
        } else {
            this.writeStartArray(fieldName);
        }
        for (T element : array) {
            if (element == null) {
                if (skipNullElements) continue;
                this.writeNull();
                continue;
            }
            func.accept(this, (JsonWriter)element);
        }
        return this.writeEndArray();
    }

    public <T> JsonWriter writeMap(Map<String, T> map, IOExceptionCheckedBiConsumer<JsonWriter, T> valueWriterFunc) throws IOException {
        return this.writeMap(map, valueWriterFunc, false);
    }

    public <T> JsonWriter writeMap(Map<String, T> map, IOExceptionCheckedBiConsumer<JsonWriter, T> valueWriterFunc, boolean skipNullValues) throws IOException {
        Objects.requireNonNull(valueWriterFunc, "'valueWriterFunc' cannot be null.");
        if (map == null) {
            return this.writeNull();
        }
        return this.writeMapInternal(null, map, valueWriterFunc, skipNullValues);
    }

    private <T> JsonWriter writeMapInternal(String fieldName, Map<String, T> map, IOExceptionCheckedBiConsumer<JsonWriter, T> valueWriterFunc, boolean skipNullValues) throws IOException {
        if (fieldName == null) {
            this.writeStartObject();
        } else {
            this.writeStartObject(fieldName);
        }
        for (Map.Entry<String, T> entry : map.entrySet()) {
            T value = entry.getValue();
            if (skipNullValues && value == null) continue;
            this.writeFieldName(entry.getKey());
            if (value == null) {
                this.writeNull();
                continue;
            }
            valueWriterFunc.accept(this, (JsonWriter)value);
        }
        return this.writeEndObject();
    }

    public JsonWriter writeBinary(byte[] value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(value);
        }
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeBoolean(boolean value) throws IOException {
        this.context.validateToken(JsonToken.BOOLEAN);
        this.generator.writeBoolean(value);
        this.context = this.context.updateContext(JsonToken.BOOLEAN);
        return this;
    }

    public JsonWriter writeBoolean(Boolean value) throws IOException {
        return value == null ? this.writeNull() : this.writeBoolean((boolean)value);
    }

    public JsonWriter writeDouble(double value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeFloat(float value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeInt(int value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeLong(long value) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(value);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    public JsonWriter writeNull() throws IOException {
        this.context.validateToken(JsonToken.NULL);
        this.generator.writeNull();
        this.context = this.context.updateContext(JsonToken.NULL);
        return this;
    }

    public JsonWriter writeNumber(Number value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return this.writeInt(value.intValue());
        }
        if (value instanceof Long) {
            return this.writeLong(value.longValue());
        }
        if (value instanceof Float) {
            return this.writeFloat(value.floatValue());
        }
        if (value instanceof Double) {
            return this.writeDouble(value.doubleValue());
        }
        return this.writeRawValue(value.toString());
    }

    public JsonWriter writeString(String value) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeString(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public JsonWriter writeRawValue(String value) throws IOException {
        Objects.requireNonNull(value, "'value' cannot be null.");
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeRawValue(value);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    public <T> JsonWriter writeNullableField(String fieldName, T nullable, IOExceptionCheckedBiConsumer<JsonWriter, T> writerFunc) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        Objects.requireNonNull(writerFunc, "'writerFunc' cannot be null.");
        if (nullable == null) {
            return this.writeNullField(fieldName);
        }
        writerFunc.accept(this.writeFieldName(fieldName), (JsonWriter)nullable);
        return this;
    }

    public JsonWriter writeJsonField(String fieldName, JsonSerializable<?> value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return value == null ? this : value.toJson(this.writeFieldName(fieldName));
    }

    public <T> JsonWriter writeArrayField(String fieldName, T[] array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc) throws IOException {
        return this.writeArrayField(fieldName, array, elementWriterFunc, false);
    }

    public <T> JsonWriter writeArrayField(String fieldName, T[] array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc, boolean skipNullElements) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        Objects.requireNonNull(elementWriterFunc, "'elementWriterFunc' cannot be null.");
        if (array == null) {
            return this;
        }
        return this.writeArrayInternal(Arrays.asList(array), elementWriterFunc, fieldName, skipNullElements);
    }

    public <T> JsonWriter writeArrayField(String fieldName, Iterable<T> array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc) throws IOException {
        return this.writeArrayField(fieldName, array, elementWriterFunc, false);
    }

    public <T> JsonWriter writeArrayField(String fieldName, Iterable<T> array, IOExceptionCheckedBiConsumer<JsonWriter, T> elementWriterFunc, boolean skipNullElements) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        Objects.requireNonNull(elementWriterFunc, "'elementWriterFunc' cannot be null.");
        if (array == null) {
            return this;
        }
        return this.writeArrayInternal(array, elementWriterFunc, fieldName, skipNullElements);
    }

    public <T> JsonWriter writeMapField(String fieldName, Map<String, T> map, IOExceptionCheckedBiConsumer<JsonWriter, T> valueWriterFunc) throws IOException {
        return this.writeMapField(fieldName, map, valueWriterFunc, false);
    }

    public <T> JsonWriter writeMapField(String fieldName, Map<String, T> map, IOExceptionCheckedBiConsumer<JsonWriter, T> valueWriterFunc, boolean skipNullValues) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        Objects.requireNonNull(valueWriterFunc, "'valueWriterFunc' cannot be null.");
        if (map == null) {
            return this;
        }
        return this.writeMapInternal(fieldName, map, valueWriterFunc, skipNullValues);
    }

    public JsonWriter writeBinaryField(String fieldName, byte[] value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        if (value == null) {
            return this;
        }
        return this.writeFieldName(fieldName).writeBinary(value);
    }

    public JsonWriter writeBooleanField(String fieldName, boolean value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeBoolean(value);
    }

    public JsonWriter writeBooleanField(String fieldName, Boolean value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return value == null ? this : this.writeBooleanField(fieldName, (boolean)value);
    }

    public JsonWriter writeDoubleField(String fieldName, double value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeDouble(value);
    }

    public JsonWriter writeFloatField(String fieldName, float value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeFloat(value);
    }

    public JsonWriter writeIntField(String fieldName, int value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeInt(value);
    }

    public JsonWriter writeLongField(String fieldName, long value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeLong(value);
    }

    public JsonWriter writeNullField(String fieldName) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeNull();
    }

    public JsonWriter writeNumberField(String fieldName, Number value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        if (value == null) {
            return this;
        }
        return this.writeFieldName(fieldName).writeNumber(value);
    }

    public JsonWriter writeStringField(String fieldName, String value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        if (value == null) {
            return this;
        }
        return this.writeFieldName(fieldName).writeString(value);
    }

    public JsonWriter writeRawField(String fieldName, String value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        return this.writeFieldName(fieldName).writeRawValue(value);
    }

    public JsonWriter writeUntypedField(String fieldName, Object value) throws IOException {
        Objects.requireNonNull(fieldName, "'fieldName' cannot be null.");
        return this.writeFieldName(fieldName).writeUntyped(value);
    }

    public JsonWriter writeUntyped(Object value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        if (value instanceof Short) {
            return this.writeInt(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return this.writeInt((Integer)value);
        }
        if (value instanceof Long) {
            return this.writeLong((Long)value);
        }
        if (value instanceof Float) {
            return this.writeFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.writeDouble((Double)value);
        }
        if (value instanceof Boolean) {
            return this.writeBoolean((boolean)((Boolean)value));
        }
        if (value instanceof byte[]) {
            return this.writeBinary((byte[])value);
        }
        if (value instanceof CharSequence) {
            return this.writeString(String.valueOf(value));
        }
        if (value instanceof Character) {
            return this.writeString(String.valueOf(((Character)value).charValue()));
        }
        if (value instanceof JsonSerializable) {
            return ((JsonSerializable)value).toJson(this);
        }
        if (value instanceof BinaryData) {
            ((BinaryData)value).writeTo(this);
            return this;
        }
        if (value instanceof Object[]) {
            this.writeStartArray();
            for (Object element : (Object[])value) {
                this.writeUntyped(element);
            }
            return this.writeEndArray();
        }
        if (value instanceof Iterable) {
            this.writeStartArray();
            for (Object element : (Iterable)value) {
                this.writeUntyped(element);
            }
            return this.writeEndArray();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            this.writeStartObject();
            for (Map.Entry entry : mapValue.entrySet()) {
                this.writeFieldName(String.valueOf(entry.getKey())).writeUntyped(entry.getValue());
            }
            return this.writeEndObject();
        }
        if (value.getClass() == Object.class) {
            return this.writeStartObject().writeEndObject();
        }
        return this.writeString(String.valueOf(value));
    }
}

