/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.implementation.utils.SliceInputStream;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class FileBinaryData
extends BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(FileBinaryData.class);
    private final Path file;
    private final int chunkSize;
    private final long position;
    private final long length;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<FileBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FileBinaryData.class, byte[].class, "bytes");

    public FileBinaryData(Path file, int chunkSize, Long position, Long length) {
        this(FileBinaryData.validateFile(file), FileBinaryData.validateChunkSize(chunkSize), FileBinaryData.validatePosition(position), FileBinaryData.validateLength(length, file.toFile().length(), FileBinaryData.validatePosition(position)));
    }

    FileBinaryData(Path file, int chunkSize, long position, long length) {
        this.file = file;
        this.chunkSize = chunkSize;
        this.position = position;
        this.length = length;
    }

    private static Path validateFile(Path file) {
        Objects.requireNonNull(file, "'file' cannot be null.");
        if (!file.toFile().exists()) {
            throw LOGGER.throwableAtError().addKeyValue("file", file.toString()).log("File does not exist.", CoreException::from);
        }
        return file;
    }

    private static int validateChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw LOGGER.throwableAtError().log("'chunkSize' cannot be less than or equal to 0.", IllegalArgumentException::new);
        }
        return chunkSize;
    }

    private static long validatePosition(Long position) {
        if (position != null && position < 0L) {
            throw LOGGER.throwableAtError().log("'position' cannot be negative.", IllegalArgumentException::new);
        }
        return position != null ? position : 0L;
    }

    private static long validateLength(Long length, long fileLength, long position) {
        if (length != null && length < 0L) {
            throw LOGGER.throwableAtError().log("'length' cannot be negative.", IllegalArgumentException::new);
        }
        long maxAvailableLength = fileLength - position;
        return length == null ? maxAvailableLength : Math.min(length, maxAvailableLength);
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        if (this.length > 0x7FFFFFF7L) {
            throw LOGGER.throwableAtError().log("The content length is too large for a byte array. Content length is: " + this.length, IllegalStateException::new);
        }
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(Type type, ObjectSerializer serializer) {
        try {
            return serializer.deserializeFromStream(this.toStream(), type);
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    @Override
    public InputStream toStream() {
        try {
            return new SliceInputStream(new BufferedInputStream(this.getFileInputStream(), this.chunkSize), this.position, this.length);
        }
        catch (FileNotFoundException e) {
            throw LOGGER.throwableAtError().addKeyValue("file", this.file.toString()).log("File not found", e, CoreException::from);
        }
    }

    FileInputStream getFileInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file.toFile());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        if (this.length > 0x7FFFFFF7L) {
            throw LOGGER.throwableAtError().log("The content length is too large for a byte array. Content length is: " + this.length, IllegalStateException::new);
        }
        return this.toByteBufferInternal();
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.writeTo(Channels.newChannel(outputStream));
    }

    @Override
    public void writeTo(WritableByteChannel channel) {
        try (FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);){
            fileChannel.transferTo(this.position, this.length, channel);
        }
        catch (IOException exception) {
            throw LOGGER.throwableAtError().log(exception, CoreException::from);
        }
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        try {
            jsonWriter.writeBinary(this.toBytes());
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    ByteBuffer toByteBufferInternal() {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, this.length);
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw LOGGER.throwableAtError().log(exception, CoreException::from);
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryData toReplayableBinaryData() {
        return this;
    }

    private byte[] getBytes() {
        byte[] byArray;
        block11: {
            if (this.length > 0x7FFFFFF7L) {
                throw LOGGER.throwableAtError().log("The content length is too large for a byte array. Content length is: " + this.length, IllegalStateException::new);
            }
            InputStream is = this.toStream();
            try {
                int read;
                byte[] bytes = new byte[(int)this.length];
                int pendingBytes = bytes.length;
                int offset = 0;
                do {
                    if ((read = is.read(bytes, offset, pendingBytes)) >= 0) {
                        offset += read;
                        continue;
                    }
                    throw LOGGER.throwableAtError().log("Premature EOF. File was modified concurrently.", IllegalStateException::new);
                } while ((pendingBytes -= read) > 0);
                byArray = bytes;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw LOGGER.throwableAtError().log(exception, CoreException::from);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public void close() {
    }
}

