/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation;

import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.implementation.instrumentation.InstrumentationUtils;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackInstrumentation;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.OTelInstrumentation;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.InstrumentationOptions;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.metrics.Meter;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.Tracer;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Instrumentation {
    public Tracer getTracer();

    public Meter getMeter();

    public InstrumentationAttributes createAttributes(Map<String, Object> var1);

    public TraceContextPropagator getW3CTraceContextPropagator();

    public <TResponse> TResponse instrumentWithResponse(String var1, RequestContext var2, Function<RequestContext, TResponse> var3);

    default public void instrument(String operationName, RequestContext requestContext, Consumer<RequestContext> operation) {
        this.instrumentWithResponse(operationName, requestContext, updatedContext -> {
            operation.accept((RequestContext)updatedContext);
            return null;
        });
    }

    public static Instrumentation create(InstrumentationOptions applicationOptions, SdkInstrumentationOptions sdkOptions) {
        Objects.requireNonNull(sdkOptions, "'sdkOptions' cannot be null");
        String host = null;
        int port = -1;
        if (sdkOptions.getEndpoint() != null) {
            URI uri = URI.create(sdkOptions.getEndpoint());
            host = uri.getHost();
            port = InstrumentationUtils.getServerPort(uri);
        }
        if (OTelInitializer.isInitialized()) {
            return new OTelInstrumentation(applicationOptions, sdkOptions, host, port);
        }
        return new FallbackInstrumentation(applicationOptions, sdkOptions, host, port);
    }

    public static <T> InstrumentationContext createInstrumentationContext(T context) {
        if (OTelInitializer.isInitialized()) {
            return OTelInstrumentation.DEFAULT_INSTANCE.createInstrumentationContext(context);
        }
        return FallbackInstrumentation.DEFAULT_INSTANCE.createInstrumentationContext(context);
    }
}

