/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.CoreUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Providers<TProvider, TInstance> {
    private static final ClientLogger LOGGER = new ClientLogger(Providers.class);
    private final TProvider defaultProvider;
    private final String defaultProviderName;
    private final Map<String, TProvider> availableProviders;
    private final String defaultImplementation;
    private final boolean noDefaultImplementation;
    private final String noProviderMessage;
    private final Class<TProvider> providerClass;

    public Providers(Class<TProvider> providerClass, String defaultImplementationName, String noProviderErrorMessage) {
        this.providerClass = providerClass;
        ServiceLoader<TProvider> serviceLoader = ServiceLoader.load(providerClass, Providers.class.getClassLoader());
        Object defaultProvider = null;
        String defaultProviderName = null;
        this.availableProviders = new HashMap<String, TProvider>();
        Iterator<TProvider> it = serviceLoader.iterator();
        while (it.hasNext()) {
            try {
                TProvider provider = it.next();
                String providerName = provider.getClass().getName();
                this.availableProviders.put(providerName, provider);
                if (defaultProvider == null) {
                    defaultProvider = provider;
                    defaultProviderName = providerName;
                    LOGGER.atVerbose().addKeyValue("providerName", providerName).addKeyValue("providerClass", providerClass.getName()).log("Loaded default provider.");
                    continue;
                }
                LOGGER.atVerbose().addKeyValue("providerName", providerName).log("Additional provider found on the classpath");
            }
            catch (LinkageError | ServiceConfigurationError error) {
                LOGGER.atWarning().setThrowable(error).log("Failed to load a provider instance.");
            }
        }
        this.defaultProvider = defaultProvider;
        this.defaultProviderName = defaultProviderName;
        this.defaultImplementation = defaultImplementationName;
        this.noDefaultImplementation = CoreUtils.isNullOrEmpty(this.defaultImplementation);
        this.noProviderMessage = noProviderErrorMessage;
    }

    private String formatNoSpecificProviderErrorMessage(String selectedImplementation) {
        return "A request was made to use a specific " + this.providerClass.getSimpleName() + " but it wasn't found on the classpath. If you're using a dependency manager ensure you're including the dependency that provides the specific implementation. If you're including the specific implementation ensure that the " + this.providerClass.getSimpleName() + " service it supplies is being included in the 'META-INF/services' file '" + this.providerClass.getName() + "'. The requested provider was: " + selectedImplementation + ".";
    }

    public TInstance create(Function<TProvider, TInstance> createInstance, Supplier<TInstance> fallbackSupplier, Class<? extends TProvider> selectedImplementation) {
        TProvider provider;
        String implementationName;
        if (selectedImplementation == null && this.noDefaultImplementation) {
            implementationName = this.defaultProviderName;
            provider = this.defaultProvider;
            if (provider == null) {
                TInstance instance;
                TInstance TInstance = instance = fallbackSupplier == null ? null : (TInstance)fallbackSupplier.get();
                if (instance == null) {
                    throw LOGGER.throwableAtError().log(this.noProviderMessage, IllegalStateException::new);
                }
                return instance;
            }
        } else {
            implementationName = selectedImplementation == null ? this.defaultImplementation : selectedImplementation.getName();
            provider = this.availableProviders.get(implementationName);
            if (provider == null) {
                throw LOGGER.throwableAtError().log(this.formatNoSpecificProviderErrorMessage(implementationName), IllegalStateException::new);
            }
        }
        try {
            return createInstance.apply(provider);
        }
        catch (ClassCastException ex) {
            throw LOGGER.throwableAtError().log(this.formatNoSpecificProviderErrorMessage(implementationName), ex, IllegalStateException::new);
        }
    }
}

