/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.tracing;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpanBuilder;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.Tracer;

public final class OTelTracer
implements Tracer {
    public static final OTelTracer NOOP = new OTelTracer();
    private static final ClientLogger LOGGER = new ClientLogger(OTelTracer.class);
    private static final FallbackInvoker SPAN_BUILDER_INVOKER;
    private static final FallbackInvoker SET_INSTRUMENTATION_VERSION_INVOKER;
    private static final FallbackInvoker BUILD_INVOKER;
    private static final FallbackInvoker SET_SCHEMA_URL_INVOKER;
    private static final FallbackInvoker GET_TRACER_BUILDER_INVOKER;
    private final Object otelTracer;
    private final SdkInstrumentationOptions sdkOptions;

    private OTelTracer() {
        this.otelTracer = null;
        this.sdkOptions = null;
    }

    public OTelTracer(Object otelTracerProvider, SdkInstrumentationOptions sdkOptions) {
        Object tracerBuilder = GET_TRACER_BUILDER_INVOKER.invoke(otelTracerProvider, sdkOptions.getSdkName());
        if (tracerBuilder != null) {
            SET_INSTRUMENTATION_VERSION_INVOKER.invoke(tracerBuilder, sdkOptions.getSdkVersion());
            SET_SCHEMA_URL_INVOKER.invoke(tracerBuilder, sdkOptions.getSchemaUrl());
            this.otelTracer = BUILD_INVOKER.invoke(tracerBuilder);
        } else {
            this.otelTracer = null;
        }
        this.sdkOptions = sdkOptions;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName, SpanKind spanKind, InstrumentationContext parentContext) {
        Object otelSpanBuilder;
        if (this.isEnabled() && (otelSpanBuilder = SPAN_BUILDER_INVOKER.invoke(this.otelTracer, spanName)) != null) {
            return new OTelSpanBuilder(otelSpanBuilder, spanKind, parentContext, this.sdkOptions);
        }
        return OTelSpanBuilder.NOOP;
    }

    @Override
    public boolean isEnabled() {
        return this.otelTracer != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker spanBuilderInvoker = null;
        ReflectiveInvoker setInstrumentationVersionInvoker = null;
        ReflectiveInvoker buildInvoker = null;
        ReflectiveInvoker setSchemaUrlInvoker = null;
        ReflectiveInvoker getTracerBuilderInvoker = null;
        if (OTelInitializer.isInitialized()) {
            try {
                spanBuilderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_CLASS, OTelInitializer.TRACER_CLASS.getMethod("spanBuilder", String.class));
                setInstrumentationVersionInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_BUILDER_CLASS, OTelInitializer.TRACER_BUILDER_CLASS.getMethod("setInstrumentationVersion", String.class));
                setSchemaUrlInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_BUILDER_CLASS, OTelInitializer.TRACER_BUILDER_CLASS.getMethod("setSchemaUrl", String.class));
                buildInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_BUILDER_CLASS, OTelInitializer.TRACER_BUILDER_CLASS.getMethod("build", new Class[0]));
                getTracerBuilderInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TRACER_PROVIDER_CLASS, OTelInitializer.TRACER_PROVIDER_CLASS.getMethod("tracerBuilder", String.class));
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        SPAN_BUILDER_INVOKER = new FallbackInvoker(spanBuilderInvoker, LOGGER);
        SET_INSTRUMENTATION_VERSION_INVOKER = new FallbackInvoker(setInstrumentationVersionInvoker, LOGGER);
        SET_SCHEMA_URL_INVOKER = new FallbackInvoker(setSchemaUrlInvoker, LOGGER);
        BUILD_INVOKER = new FallbackInvoker(buildInvoker, LOGGER);
        GET_TRACER_BUILDER_INVOKER = new FallbackInvoker(getTracerBuilderInvoker, LOGGER);
    }
}

