/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.tracing;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelContext;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpanContext;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.TraceContextGetter;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.TraceContextSetter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OTelTraceContextPropagator
implements TraceContextPropagator {
    public static final TraceContextPropagator NOOP = new OTelTraceContextPropagator(null);
    private static final ClientLogger LOGGER = new ClientLogger(OTelTraceContextPropagator.class);
    private static final FallbackInvoker INJECT_INVOKER;
    private static final FallbackInvoker EXTRACT_INVOKER;
    private final Object otelPropagator;

    public OTelTraceContextPropagator(Object otelPropagator) {
        this.otelPropagator = otelPropagator;
    }

    @Override
    public <C> void inject(InstrumentationContext context, C carrier, TraceContextSetter<C> setter) {
        if (this.isInitialized()) {
            INJECT_INVOKER.invoke(this.otelPropagator, OTelContext.fromInstrumentationContext(context), carrier, Setter.toOTelSetter(setter));
        }
    }

    @Override
    public <C> InstrumentationContext extract(InstrumentationContext context, C carrier, TraceContextGetter<C> getter) {
        Object updatedContext;
        if (this.isInitialized() && (updatedContext = EXTRACT_INVOKER.invoke(this.otelPropagator, OTelContext.fromInstrumentationContext(context), carrier, Getter.toOTelGetter(getter))) != null) {
            return OTelSpanContext.fromOTelContext(updatedContext);
        }
        return context;
    }

    private boolean isInitialized() {
        return this.otelPropagator != null && OTelInitializer.isInitialized();
    }

    static {
        ReflectiveInvoker injectInvoker = null;
        ReflectiveInvoker extractInvoker = null;
        if (OTelInitializer.isInitialized()) {
            try {
                injectInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TEXT_MAP_PROPAGATOR_CLASS, OTelInitializer.TEXT_MAP_PROPAGATOR_CLASS.getMethod("inject", OTelInitializer.CONTEXT_CLASS, Object.class, OTelInitializer.TEXT_MAP_SETTER_CLASS));
                extractInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.TEXT_MAP_PROPAGATOR_CLASS, OTelInitializer.TEXT_MAP_PROPAGATOR_CLASS.getMethod("extract", OTelInitializer.CONTEXT_CLASS, Object.class, OTelInitializer.TEXT_MAP_GETTER_CLASS));
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        INJECT_INVOKER = new FallbackInvoker(injectInvoker, LOGGER);
        EXTRACT_INVOKER = new FallbackInvoker(extractInvoker, LOGGER);
    }

    private static final class Setter<C>
    implements InvocationHandler {
        private static final Class<?>[] INTERFACES = new Class[]{OTelInitializer.TEXT_MAP_SETTER_CLASS};
        private static final Map<TraceContextSetter<?>, Object> PROXIES = new ConcurrentHashMap();
        private final TraceContextSetter<C> setter;

        static Object toOTelSetter(TraceContextSetter<?> setter) {
            return PROXIES.computeIfAbsent(setter, s -> Proxy.newProxyInstance(OTelInitializer.TEXT_MAP_SETTER_CLASS.getClassLoader(), INTERFACES, new Setter(s)));
        }

        private Setter(TraceContextSetter<C> setter) {
            this.setter = setter;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if ("set".equals(method.getName())) {
                assert (args.length == 3);
                this.setter.set(args[0], (String)args[1], (String)args[2]);
            }
            return null;
        }
    }

    private static final class Getter<C>
    implements InvocationHandler {
        private static final Class<?>[] INTERFACES = new Class[]{OTelInitializer.TEXT_MAP_GETTER_CLASS};
        private static final Map<TraceContextGetter<?>, Object> PROXIES = new ConcurrentHashMap();
        private final TraceContextGetter<C> getter;

        static Object toOTelGetter(TraceContextGetter<?> getter) {
            return PROXIES.computeIfAbsent(getter, g -> Proxy.newProxyInstance(OTelInitializer.TEXT_MAP_GETTER_CLASS.getClassLoader(), INTERFACES, new Getter(g)));
        }

        private Getter(TraceContextGetter<C> getter) {
            this.getter = getter;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if ("get".equals(method.getName())) {
                assert (args.length == 2);
                return this.getter.get(args[0], (String)args[1]);
            }
            if ("keys".equals(method.getName())) {
                assert (args.length == 1);
                return this.getter.keys(args[0]);
            }
            return null;
        }
    }
}

