/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackScope;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpan;
import io.clientcore.core.implementation.instrumentation.fallback.RandomIdUtils;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.tracing.Span;

final class FallbackSpanContext
implements InstrumentationContext {
    static final FallbackSpanContext INVALID = new FallbackSpanContext("00000000000000000000000000000000", "0000000000000000", "00", false, Span.noop());
    private final String traceId;
    private final String spanId;
    private final String traceFlags;
    private final boolean isValid;
    private final Span span;

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    @Override
    public String getTraceFlags() {
        return this.traceFlags;
    }

    FallbackSpanContext(String traceId, String spanId, String traceFlags, boolean isValid, Span span) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceFlags = traceFlags;
        this.isValid = isValid;
        this.span = span;
    }

    static FallbackSpanContext fromParent(InstrumentationContext parent, boolean isSampled, FallbackSpan span) {
        return parent.isValid() ? new FallbackSpanContext(parent.getTraceId(), RandomIdUtils.generateSpanId(), isSampled ? "01" : "00", true, span) : new FallbackSpanContext(RandomIdUtils.generateTraceId(), RandomIdUtils.generateSpanId(), isSampled ? "01" : "00", true, span);
    }

    static FallbackSpanContext fromInstrumentationContext(InstrumentationContext instrumentationContext) {
        if (instrumentationContext instanceof FallbackSpanContext) {
            return (FallbackSpanContext)instrumentationContext;
        }
        if (instrumentationContext != null) {
            return new FallbackSpanContext(instrumentationContext.getTraceId(), instrumentationContext.getSpanId(), instrumentationContext.getTraceFlags(), instrumentationContext.isValid(), instrumentationContext.getSpan());
        }
        Span currentSpan = FallbackScope.getCurrentSpan();
        if (currentSpan != Span.noop()) {
            return (FallbackSpanContext)currentSpan.getInstrumentationContext();
        }
        return INVALID;
    }
}

