/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackScope;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpanContext;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.TracingScope;

final class FallbackSpan
implements Span {
    private final LoggingEvent log;
    private final long startTime;
    private final FallbackSpanContext spanContext;
    private final SpanKind kind;
    private String errorType;

    FallbackSpan(LoggingEvent log, SpanKind spanKind, FallbackSpanContext parentSpanContext, boolean isRecording) {
        this.log = log;
        this.startTime = isRecording ? System.nanoTime() : 0L;
        this.kind = spanKind;
        this.spanContext = FallbackSpanContext.fromParent(parentSpanContext, isRecording, this);
        if (log != null && log.isEnabled()) {
            this.log.addKeyValue("trace.id", this.spanContext.getTraceId()).addKeyValue("span.id", this.spanContext.getSpanId());
        }
    }

    @Override
    public Span setAttribute(String key, Object value) {
        if (this.log != null) {
            this.log.addKeyValue(key, value);
        }
        return this;
    }

    @Override
    public Span setError(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Override
    public void end() {
        this.end(null);
    }

    @Override
    public void end(Throwable error) {
        if (this.log == null || !this.log.isEnabled()) {
            return;
        }
        double durationMs = (double)(System.nanoTime() - this.startTime) / 1000000.0;
        this.log.addKeyValue("span.duration", durationMs);
        if (error != null || this.errorType != null) {
            this.setAttribute("error.type", this.errorType != null ? this.errorType : error.getClass().getCanonicalName());
        }
        this.log.setEventName("span.ended");
        this.log.log();
    }

    public SpanKind getSpanKind() {
        return this.kind;
    }

    @Override
    public boolean isRecording() {
        return this.log != null && this.log.isEnabled();
    }

    @Override
    public TracingScope makeCurrent() {
        return new FallbackScope(this);
    }

    @Override
    public InstrumentationContext getInstrumentationContext() {
        return this.spanContext;
    }
}

