/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpan;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.TracingScope;

final class FallbackScope
implements TracingScope {
    private static final ClientLogger LOGGER = new ClientLogger(FallbackScope.class);
    private static final ThreadLocal<FallbackSpan> CURRENT_SPAN = new ThreadLocal();
    private final FallbackSpan originalSpan = CURRENT_SPAN.get();
    private final FallbackSpan span;

    FallbackScope(FallbackSpan span) {
        this.span = span;
        CURRENT_SPAN.set(span);
    }

    @Override
    public void close() {
        if (CURRENT_SPAN.get() == this.span) {
            CURRENT_SPAN.set(this.originalSpan);
        } else {
            LOGGER.atVerbose().log("Attempting to close scope that is not the current. Ignoring.");
        }
    }

    static Span getCurrentSpan() {
        FallbackSpan span = CURRENT_SPAN.get();
        return span == null ? Span.noop() : span;
    }
}

