/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePosition;
import io.clientcore.core.http.pipeline.UserAgentOptions;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.configuration.Configuration;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private final String userAgent;
    static final String DEFAULT_USER_AGENT_HEADER = "sdk-java";

    public UserAgentPolicy() {
        this((String)null);
    }

    public UserAgentPolicy(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : DEFAULT_USER_AGENT_HEADER;
    }

    public UserAgentPolicy(UserAgentOptions userAgentOptions) {
        this.userAgent = UserAgentPolicy.toUserAgentString(userAgentOptions);
    }

    @Override
    public Response<BinaryData> process(HttpRequest httpRequest, HttpPipelineNextPolicy next) {
        httpRequest.getHeaders().set(HttpHeaderName.USER_AGENT, this.userAgent);
        return next.process();
    }

    @Override
    public final HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.BEFORE_REDIRECT;
    }

    private static String toUserAgentString(UserAgentOptions userAgentOptions) {
        StringBuilder userAgentBuilder = new StringBuilder();
        String applicationId = userAgentOptions.getApplicationId();
        if (!CoreUtils.isNullOrEmpty(applicationId)) {
            if (applicationId.contains(" ")) {
                throw new IllegalArgumentException("'applicationid' cannot contain spaces.");
            }
            userAgentBuilder.append(applicationId).append(" ");
        }
        userAgentBuilder.append(DEFAULT_USER_AGENT_HEADER).append("-").append(userAgentOptions.getSdkName()).append("/").append(userAgentOptions.getSdkVersion());
        UserAgentPolicy.appendPlatformInfo(userAgentBuilder);
        return userAgentBuilder.toString();
    }

    private static void appendPlatformInfo(StringBuilder stringBuilder) {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osVersion = Configuration.getGlobalConfiguration().get("os.version");
        stringBuilder.append(" (").append(javaVersion).append("; ").append(osName).append("; ").append(osVersion).append(")");
    }
}

