/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.Response;
import io.clientcore.core.models.binarydata.BinaryData;
import java.util.Collections;
import java.util.List;

public final class HttpRetryCondition {
    private final Response<BinaryData> response;
    private final Exception exception;
    private final int tryCount;
    private final List<Exception> retriedExceptions;

    HttpRetryCondition(Response<BinaryData> response, Exception exception, int tryCount, List<Exception> retriedExceptions) {
        this.response = response;
        this.exception = exception;
        this.tryCount = tryCount;
        this.retriedExceptions = retriedExceptions == null ? Collections.emptyList() : Collections.unmodifiableList(retriedExceptions);
    }

    public Response<BinaryData> getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public List<Exception> getRetriedExceptions() {
        return this.retriedExceptions;
    }
}

