/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.client;

import io.clientcore.core.http.client.HttpClient;
import io.clientcore.core.implementation.utils.Providers;
import io.clientcore.core.utils.configuration.Configuration;

public abstract class HttpClientProvider {
    static final String NO_DEFAULT_PROVIDER_MESSAGE = "A request was made to load the default HttpClient provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on supported implementations of HTTP clients. Please refer to https://aka.ms/java/docs/httpclients for more information.";
    private static Providers<HttpClientProvider, HttpClient> providers;

    public abstract HttpClient getNewInstance();

    public abstract HttpClient getSharedInstance();

    static Providers<HttpClientProvider, HttpClient> getProviders() {
        if (providers == null) {
            providers = new Providers(HttpClientProvider.class, Configuration.getGlobalConfiguration().get("HTTP_CLIENT_IMPLEMENTATION"), NO_DEFAULT_PROVIDER_MESSAGE);
        }
        return providers;
    }
}

