/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.utils.SharedExecutorService;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class JdkHttpUtils {
    static HttpHeaders fromJdkHttpHeaders(java.net.http.HttpHeaders headers) {
        HttpHeaders httpHeaders = new HttpHeaders((int)((float)headers.map().size() / 0.75f));
        for (Map.Entry<String, List<String>> kvp : headers.map().entrySet()) {
            List<String> value = kvp.getValue();
            if (value == null || value.isEmpty()) continue;
            httpHeaders.set(HttpHeaderName.fromString(kvp.getKey()), kvp.getValue());
        }
        return httpHeaders;
    }

    static int getSizeOfBuffers(List<ByteBuffer> buffers) {
        long size = 0L;
        for (ByteBuffer buffer : buffers) {
            if ((size += (long)buffer.remaining()) <= Integer.MAX_VALUE) continue;
            throw new IllegalStateException("The size of the buffers is greater than Integer.MAX_VALUE.");
        }
        return (int)size;
    }

    static ScheduledFuture<?> scheduleTimeoutTask(Runnable task, long timeoutMillis) {
        return SharedExecutorService.getInstance().schedule(task, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private JdkHttpUtils() {
    }
}

