/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.client;

import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.implementation.http.client.BodyPublisherUtils;
import io.clientcore.core.implementation.http.client.HeaderFilteringMap;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

final class JdkHttpRequest
extends java.net.http.HttpRequest {
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String method;
    private final URI uri;
    private final HttpHeaders headers;
    private final Optional<Duration> responseTimeout;

    JdkHttpRequest(HttpRequest coreRequest, Set<String> restrictedHeaders, ClientLogger logger, Duration writeTimeout, Duration responseTimeout) {
        HttpMethod method = coreRequest.getHttpMethod();
        this.method = method.toString();
        this.bodyPublisher = method == HttpMethod.GET || method == HttpMethod.HEAD ? HttpRequest.BodyPublishers.noBody() : BodyPublisherUtils.toBodyPublisher(coreRequest, writeTimeout);
        this.uri = coreRequest.getUri();
        this.headers = HttpHeaders.of(new HeaderFilteringMap(coreRequest.getHeaders(), restrictedHeaders, logger), (ignored1, ignored2) -> true);
        this.responseTimeout = Optional.ofNullable(responseTimeout);
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.ofNullable(this.bodyPublisher);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Optional<Duration> timeout() {
        return this.responseTimeout;
    }

    @Override
    public boolean expectContinue() {
        return false;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }
}

