/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.templating;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.models.TemplateInput;
import io.clientcore.annotation.processor.templating.TemplateProcessor;
import io.clientcore.annotation.processor.utils.CodeGenUtils;
import io.clientcore.annotation.processor.utils.RequestBodyHandler;
import io.clientcore.annotation.processor.utils.ResponseHandler;
import io.clientcore.annotation.processor.utils.TypeConverter;
import io.clientcore.core.http.annotations.HostParam;
import io.clientcore.core.http.models.HttpHeader;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.xml.XmlSerializer;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.GeneratedCodeUtils;
import io.clientcore.core.utils.UriBuilder;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class JavaParserTemplateProcessor
implements TemplateProcessor {
    private static final Map<String, String> LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT = new HashMap<String, String>();
    private final CompilationUnit compilationUnit = new CompilationUnit();
    private final Map<String, String> httpHeaderNameConstantsToAdd = new TreeMap<String, String>(String::compareToIgnoreCase);
    private ClassOrInterfaceDeclaration classBuilder;

    @Override
    public void process(TemplateInput templateInput, ProcessingEnvironment processingEnv) {
        String packageName = templateInput.getPackageName();
        packageName = packageName.substring(0, packageName.lastIndexOf(46));
        String serviceInterfaceImplShortName = templateInput.getServiceInterfaceImplShortName();
        String serviceInterfaceShortName = templateInput.getServiceInterfaceShortName();
        this.addImports(templateInput);
        this.addCopyrightComments();
        this.setPackageDeclaration(packageName);
        this.createClass(serviceInterfaceImplShortName, serviceInterfaceShortName, templateInput, processingEnv);
        processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing generated source file for: " + serviceInterfaceImplShortName);
        this.writeFile(packageName, serviceInterfaceImplShortName, processingEnv);
        processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Completed code generation for: " + serviceInterfaceImplShortName);
    }

    void addImports(TemplateInput templateInput) {
        templateInput.getImports().keySet().forEach(arg_0 -> ((CompilationUnit)this.compilationUnit).addImport(arg_0));
    }

    void addCopyrightComments() {
        this.compilationUnit.addOrphanComment((Comment)new LineComment(" Copyright (c) Microsoft Corporation. All rights reserved."));
        this.compilationUnit.addOrphanComment((Comment)new LineComment(" Licensed under the MIT License."));
    }

    void setPackageDeclaration(String packageName) {
        this.compilationUnit.setPackageDeclaration(packageName);
    }

    void createClass(String serviceInterfaceImplShortName, String serviceInterfaceShortName, TemplateInput templateInput, ProcessingEnvironment processingEnv) {
        this.classBuilder = this.compilationUnit.addClass(serviceInterfaceImplShortName, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.classBuilder.setJavadocComment("Initializes a new instance of the " + serviceInterfaceImplShortName + " type.");
        String serviceInterfacePackage = templateInput.getServiceInterfaceFQN().substring(0, templateInput.getServiceInterfaceFQN().lastIndexOf(46));
        this.compilationUnit.addImport(serviceInterfacePackage + "." + serviceInterfaceShortName);
        this.classBuilder.addImplementedType(serviceInterfaceShortName);
        this.addLoggerField(serviceInterfaceShortName);
        this.addHttpPipelineField();
        this.addSerializerFields();
        this.addConstructor();
        this.addGetNewInstanceMethod(serviceInterfaceImplShortName, serviceInterfaceShortName);
        for (HttpRequestContext method : templateInput.getHttpRequestContexts()) {
            if (method.isConvenience()) continue;
            this.configureInternalMethod(this.classBuilder.addMethod(method.getMethodName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}), method, processingEnv);
        }
        ArrayList<FieldDeclaration> headerConstants = new ArrayList<FieldDeclaration>();
        for (Map.Entry<String, String> e : this.httpHeaderNameConstantsToAdd.entrySet()) {
            headerConstants.add((FieldDeclaration)((FieldDeclaration)new FieldDeclaration().setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL})).addVariable(((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType("HttpHeaderName")).setName(e.getKey())).setInitializer("HttpHeaderName.fromString(\"" + e.getValue() + "\")")));
        }
        if (!headerConstants.isEmpty()) {
            this.classBuilder.getMembers().addAll(0, headerConstants);
        }
    }

    private void addLoggerField(String serviceInterfaceShortName) {
        this.configureLoggerField(this.classBuilder.addField("ClientLogger", "LOGGER", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL}), serviceInterfaceShortName);
    }

    private void addHttpPipelineField() {
        this.classBuilder.addField(HttpPipeline.class, "httpPipeline", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
    }

    private void addSerializerFields() {
        this.compilationUnit.addImport(JsonSerializer.class);
        this.classBuilder.addField(JsonSerializer.class, "jsonSerializer", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        this.compilationUnit.addImport(XmlSerializer.class);
        this.classBuilder.addField(XmlSerializer.class, "xmlSerializer", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
    }

    private void addConstructor() {
        ((ConstructorDeclaration)this.classBuilder.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE}).addParameter(HttpPipeline.class, "httpPipeline")).setBody(StaticJavaParser.parseBlock((String)"{ this.httpPipeline = httpPipeline; this.jsonSerializer = JsonSerializer.getInstance(); this.xmlSerializer = XmlSerializer.getInstance(); }"));
    }

    private void addGetNewInstanceMethod(String serviceInterfaceImplShortName, String serviceInterfaceShortName) {
        ((MethodDeclaration)((MethodDeclaration)this.classBuilder.addMethod("getNewInstance", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).setType(serviceInterfaceShortName)).addParameter(HttpPipeline.class, "httpPipeline")).setBody(StaticJavaParser.parseBlock((String)("{ return new " + serviceInterfaceImplShortName + "(httpPipeline); }"))).setJavadocComment("Creates an instance of " + serviceInterfaceShortName + " that is capable of sending requests to the service.\n@param httpPipeline The HTTP pipeline to use for sending requests.\n@return An instance of `" + serviceInterfaceShortName + "`;");
    }

    CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    void configureLoggerField(FieldDeclaration field, String serviceInterfaceShortName) {
        field.tryAddImportToParentCompilationUnit(ClientLogger.class);
        ((FieldDeclaration)field.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL})).setVariables(new NodeList((Node[])new VariableDeclarator[]{((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType("ClientLogger")).setName("LOGGER")).setInitializer("new ClientLogger(" + serviceInterfaceShortName + ".class)")}));
    }

    private void configureInternalMethod(MethodDeclaration internalMethod, HttpRequestContext method, ProcessingEnvironment processingEnv) {
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)internalMethod.setName(method.getMethodName())).addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("SuppressWarnings"), (Expression)new StringLiteralExpr("cast")))).addMarkerAnnotation(Override.class)).setType(TypeConverter.getAstType(method.getMethodReturnType()));
        method.getParameters().forEach(param -> {
            if (param.getTypeMirror().getKind() == TypeKind.DECLARED) {
                internalMethod.addParameter(new Parameter(StaticJavaParser.parseType((String)param.getShortTypeName()), param.getName()));
            } else {
                internalMethod.addParameter(new Parameter(StaticJavaParser.parseType((String)param.getTypeMirror().toString()), param.getName()));
            }
        });
        BlockStmt body = (BlockStmt)internalMethod.getBody().get();
        this.initializeHttpRequest(body, method);
        boolean serializationFormatSet = RequestBodyHandler.configureRequestBody(body, method, processingEnv);
        this.addRequestContextToRequestIfPresent(body, method);
        this.finalizeHttpRequest(body, method.getMethodReturnType(), method, serializationFormatSet);
        internalMethod.setBody(body);
    }

    private void writeFile(String packageName, String serviceInterfaceImplShortName, ProcessingEnvironment processingEnv) {
        try (Writer fileWriter = processingEnv.getFiler().createSourceFile(packageName + "." + serviceInterfaceImplShortName, new Element[0]).openWriter();){
            fileWriter.write(this.compilationUnit.toString());
            fileWriter.flush();
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write generated source file for " + serviceInterfaceImplShortName + ": " + e.getMessage());
        }
    }

    private void addRequestContextToRequestIfPresent(BlockStmt body, HttpRequestContext method) {
        boolean hasRequestContext = method.getParameters().stream().anyMatch(parameter -> "requestContext".equals(parameter.getName()) && "RequestContext".equals(parameter.getShortTypeName()));
        if (hasRequestContext) {
            Statement statement1 = StaticJavaParser.parseStatement((String)"httpRequest.setContext(requestContext);");
            Statement statement2 = StaticJavaParser.parseStatement((String)"httpRequest.getContext().getRequestCallback().accept(httpRequest);");
            body.addStatement(statement1);
            body.addStatement(statement2);
        }
    }

    void initializeHttpRequest(BlockStmt body, HttpRequestContext method) {
        body.tryAddImportToParentCompilationUnit(HttpRequest.class);
        body.tryAddImportToParentCompilationUnit(HttpMethod.class);
        VariableDeclarator variableDeclarator = ((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType(HttpRequest.class)).setName("httpRequest")).setInitializer((Expression)new MethodCallExpr((Expression)new ObjectCreationExpr().setType(HttpRequest.class), "setMethod").addArgument((Expression)new NameExpr("HttpMethod." + method.getHttpMethod())));
        VariableDeclarationExpr createHttpRequest = new VariableDeclarationExpr(variableDeclarator);
        createHttpRequest.setLineComment(" Create the HttpRequest.");
        this.setHttpRequestUri(body, (Expression)createHttpRequest, method);
        this.addHeadersToRequest(body, method);
    }

    void setHttpRequestUri(BlockStmt body, Expression createHttpRequest, HttpRequestContext method) {
        String urlStatement;
        String variableName = method.getUriParameterName();
        if (!method.isTemplateHasHost()) {
            String concatenatedHostParams = method.getParameters().stream().filter(param -> param.getVariableElement().getAnnotation(HostParam.class) != null).map(HttpRequestContext.MethodParameter::getName).collect(Collectors.joining(" + "));
            urlStatement = method.isUriNextLink() || CoreUtils.isNullOrEmpty((CharSequence)concatenatedHostParams) ? method.getHost() : concatenatedHostParams + " + \"/\" + " + method.getHost();
        } else {
            urlStatement = method.getHost();
        }
        if (method.getQueryParams().isEmpty()) {
            body.addStatement((Statement)new ExpressionStmt((Expression)new MethodCallExpr(createHttpRequest, "setUri").addArgument(urlStatement)));
            return;
        }
        body.tryAddImportToParentCompilationUnit(UriBuilder.class);
        Statement uriBuilderParse = StaticJavaParser.parseStatement((String)("UriBuilder " + variableName + " = UriBuilder.parse(" + urlStatement + ");"));
        uriBuilderParse.setLineComment(" Append the query parameters.");
        body.addStatement(uriBuilderParse);
        for (Map.Entry<String, HttpRequestContext.QueryParameter> kvp : method.getQueryParams().entrySet()) {
            Object valueExpression;
            List<String> values;
            String key = kvp.getKey();
            HttpRequestContext.QueryParameter queryParameter = kvp.getValue();
            if (CoreUtils.isNullOrEmpty((CharSequence)key) || (values = queryParameter.getValues()).isEmpty()) continue;
            if (values.size() == 1) {
                String value = values.get(0);
                valueExpression = queryParameter.isStatic() ? (value == null ? new NullLiteralExpr() : new StringLiteralExpr(value)) : StaticJavaParser.parseExpression((String)value);
            } else {
                body.tryAddImportToParentCompilationUnit(Arrays.class);
                valueExpression = StaticJavaParser.parseExpression((String)("Arrays.asList(" + CodeGenUtils.toJavaArrayInitializer(values, true) + ")"));
            }
            body.tryAddImportToParentCompilationUnit(GeneratedCodeUtils.class);
            MethodCallExpr addParameterCall = (MethodCallExpr)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("GeneratedCodeUtils"), "addQueryParameter").addArgument((Expression)new NameExpr(variableName))).addArgument((Expression)new StringLiteralExpr(key))).addArgument((Expression)new BooleanLiteralExpr(!queryParameter.isStatic()))).addArgument(valueExpression)).addArgument((Expression)new BooleanLiteralExpr(queryParameter.shouldEncode()));
            body.addStatement((Statement)new ExpressionStmt((Expression)addParameterCall));
        }
        body.addStatement((Statement)new ExpressionStmt((Expression)new MethodCallExpr(createHttpRequest, "setUri").addArgument(variableName + ".toString()")));
    }

    private void addHeadersToRequest(BlockStmt body, HttpRequestContext method) {
        if (method.getHeaders().isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> header : method.getHeaders().entrySet()) {
            String valueExpression;
            String headerKey = header.getKey();
            List<String> headerValues = header.getValue();
            StringBuilder addHeader = new StringBuilder();
            String constantName = LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT.get(headerKey.toLowerCase(Locale.ROOT));
            if ("CONTENT_TYPE".equals(constantName) || headerValues.isEmpty()) continue;
            body.tryAddImportToParentCompilationUnit(HttpHeaderName.class);
            body.tryAddImportToParentCompilationUnit(HttpHeader.class);
            String ifCheck = null;
            if (headerValues.size() > 1) {
                body.tryAddImportToParentCompilationUnit(Arrays.class);
                valueExpression = "Arrays.asList(" + CodeGenUtils.toJavaArrayInitializer(headerValues, true) + ")";
            } else {
                String value = headerValues.get(0);
                Optional<HttpRequestContext.MethodParameter> paramOpt = method.getParameters().stream().filter(p -> p.getName().equals(value)).findFirst();
                if (paramOpt.isPresent()) {
                    String paramType = paramOpt.get().getShortTypeName();
                    if ("String".equals(paramType)) {
                        ifCheck = value + " != null";
                        valueExpression = value;
                    } else if ("OffsetDateTime".equals(paramType)) {
                        body.tryAddImportToParentCompilationUnit(DateTimeFormatter.class);
                        ifCheck = value + " != null";
                        valueExpression = value + ".format(DateTimeFormatter.ISO_INSTANT)";
                    } else {
                        if (!paramOpt.get().getTypeMirror().getKind().isPrimitive()) {
                            ifCheck = value + " != null";
                        }
                        valueExpression = "String.valueOf(" + value + ")";
                    }
                } else {
                    valueExpression = CodeGenUtils.quoteHeaderValue(value);
                }
            }
            if (constantName != null) {
                addHeader.append("httpRequest.getHeaders().add(new HttpHeader(HttpHeaderName.").append(constantName).append(", ").append(valueExpression).append("));");
            } else {
                String headerNameConstant = headerKey.replace('-', '_').toUpperCase(Locale.US);
                this.httpHeaderNameConstantsToAdd.put(headerNameConstant, headerKey);
                addHeader.append("httpRequest.getHeaders().add(new HttpHeader(").append(headerNameConstant).append(", ").append(valueExpression).append("));");
            }
            Statement addHeaderStatement = StaticJavaParser.parseStatement((String)addHeader.toString());
            if (ifCheck != null) {
                addHeaderStatement = new IfStmt().setCondition(StaticJavaParser.parseExpression((String)ifCheck)).setThenStmt((Statement)new BlockStmt().addStatement(addHeaderStatement));
            }
            body.addStatement(addHeaderStatement);
        }
    }

    private void finalizeHttpRequest(BlockStmt body, TypeMirror returnTypeName, HttpRequestContext method, boolean serializationFormatSet) {
        ResponseHandler.generateResponseHandling(body, returnTypeName, method, serializationFormatSet);
    }

    static {
        for (Field field : HttpHeaderName.class.getDeclaredFields()) {
            HttpHeaderName httpHeaderName;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            String constantName = field.getName();
            try {
                httpHeaderName = (HttpHeaderName)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT.put(httpHeaderName.getCaseInsensitiveName(), constantName);
        }
    }
}

