/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.VoidType;
import io.clientcore.core.http.models.Response;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class TypeConverter {
    public static Type toReflectType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: {
                return TypeConverter.handleDeclaredType(typeMirror);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return TypeConverter.getPrimitiveClass(typeMirror);
            }
            case VOID: {
                return Void.TYPE;
            }
            case ARRAY: {
                return TypeConverter.handleArrayType(typeMirror);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + typeMirror);
    }

    public static Class<?> getPrimitiveClass(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        return Object.class;
    }

    public static Type getEntityType(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case ARRAY: {
                return TypeConverter.handleArrayType(returnType);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return TypeConverter.getPrimitiveClass(returnType);
            }
            case DECLARED: {
                return TypeConverter.handleDeclaredType(returnType);
            }
        }
        return Object.class;
    }

    public static boolean isResponseType(TypeMirror returnType) {
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals(Response.class.getCanonicalName());
        }
        return false;
    }

    public static com.github.javaparser.ast.type.Type getAstType(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case VOID: {
                return new VoidType();
            }
            case BOOLEAN: {
                return PrimitiveType.booleanType();
            }
            case BYTE: {
                return PrimitiveType.byteType();
            }
            case SHORT: {
                return PrimitiveType.shortType();
            }
            case INT: {
                return PrimitiveType.intType();
            }
            case LONG: {
                return PrimitiveType.longType();
            }
            case CHAR: {
                return PrimitiveType.charType();
            }
            case FLOAT: {
                return PrimitiveType.floatType();
            }
            case DOUBLE: {
                return PrimitiveType.doubleType();
            }
            case ARRAY: {
                if (returnType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)returnType;
                    return new com.github.javaparser.ast.type.ArrayType(TypeConverter.getAstType(arrayType.getComponentType()), new AnnotationExpr[0]);
                }
                return new com.github.javaparser.ast.type.ArrayType((com.github.javaparser.ast.type.Type)TypeConverter.createObjectType(), new AnnotationExpr[0]);
            }
            case DECLARED: {
                if (returnType instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)returnType;
                    TypeElement typeElement = (TypeElement)declaredType.asElement();
                    ClassOrInterfaceType astType = new ClassOrInterfaceType(null, typeElement.getSimpleName().toString());
                    if (!declaredType.getTypeArguments().isEmpty()) {
                        List typeArguments = declaredType.getTypeArguments().stream().map(TypeConverter::getAstType).collect(Collectors.toList());
                        NodeList nodeListTypeArguments = new NodeList(typeArguments);
                        astType.setTypeArguments(nodeListTypeArguments);
                    }
                    return astType;
                }
                return TypeConverter.createObjectType();
            }
        }
        throw new IllegalArgumentException("Unsupported return type: " + returnType);
    }

    private static ClassOrInterfaceType createObjectType() {
        return new ClassOrInterfaceType("Object");
    }

    static Type handleArrayType(TypeMirror type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type componentType = TypeConverter.toReflectType(arrayType.getComponentType());
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return Object.class;
    }

    static Type handleDeclaredType(TypeMirror declaredType) {
        if (declaredType instanceof DeclaredType) {
            DeclaredType classType = (DeclaredType)declaredType;
            List<? extends TypeMirror> typeArguments = classType.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                return TypeConverter.toReflectType(typeArguments.get(0));
            }
            return TypeConverter.tryLoadClass(classType.toString());
        }
        return Object.class;
    }

    private static Type tryLoadClass(String className) {
        try {
            return Class.forName(className, true, TypeConverter.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return Object.class;
        }
    }

    private TypeConverter() {
    }
}

