/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.models;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.core.http.annotations.UnexpectedResponseExceptionDetail;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TemplateInput {
    private final Map<String, String> imports = new TreeMap<String, String>();
    private String packageName;
    private String serviceInterfaceFQN;
    private String serviceInterfaceShortName;
    private String serviceInterfaceImplShortName;
    private String host;
    private List<HttpRequestContext> httpRequestContexts;
    private List<UnexpectedResponseExceptionDetail> unexpectedResponseExceptionDetails;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getServiceInterfaceShortName() {
        return this.serviceInterfaceShortName;
    }

    public void setServiceInterfaceShortName(String serviceInterfaceShortName) {
        this.serviceInterfaceShortName = serviceInterfaceShortName;
    }

    public String getServiceInterfaceImplShortName() {
        return this.serviceInterfaceImplShortName;
    }

    public void setServiceInterfaceImplShortName(String serviceInterfaceImplShortName) {
        this.serviceInterfaceImplShortName = serviceInterfaceImplShortName;
    }

    private static String toShortName(String fqcn) {
        int lastDot = fqcn.lastIndexOf(46);
        if (lastDot > 0) {
            return fqcn.substring(lastDot + 1);
        }
        return fqcn;
    }

    public String addImport(String importFQN) {
        if (importFQN != null && !importFQN.isEmpty()) {
            String shortName = TemplateInput.toShortName(importFQN);
            this.imports.put(importFQN, shortName);
            return shortName;
        }
        return null;
    }

    public String addImport(TypeMirror type) {
        String longName = type.toString();
        String shortName = null;
        if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            String componentType = this.addImport(arrayType.getComponentType());
            return componentType + "[]";
        }
        if (type.getKind().isPrimitive()) {
            return longName;
        }
        if (this.imports.containsKey(type.toString())) {
            shortName = this.imports.get(longName);
        } else if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            String rawType = typeElement.getQualifiedName().toString();
            String shortRawType = TemplateInput.toShortName(rawType);
            this.imports.put(rawType, shortRawType);
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments != null && !typeArguments.isEmpty()) {
                List<Type> genericTypes = typeArguments.stream().map(arg -> StaticJavaParser.parseType((String)this.addImport((TypeMirror)arg))).collect(Collectors.toList());
                Type parsedRawType = StaticJavaParser.parseType((String)shortRawType);
                ClassOrInterfaceType classOrInterfaceType = new ClassOrInterfaceType(null, parsedRawType.toString());
                classOrInterfaceType.setTypeArguments(genericTypes.toArray(new Type[0]));
                shortName = classOrInterfaceType.toString();
            } else {
                shortName = shortRawType;
            }
        }
        return shortName;
    }

    public void setHttpRequestContexts(List<HttpRequestContext> httpRequestContexts) {
        this.httpRequestContexts = httpRequestContexts;
    }

    public List<HttpRequestContext> getHttpRequestContexts() {
        return this.httpRequestContexts;
    }

    public void setServiceInterfaceFQN(String serviceInterfaceFQN) {
        this.serviceInterfaceFQN = serviceInterfaceFQN;
    }

    public String getServiceInterfaceFQN() {
        return this.serviceInterfaceFQN;
    }

    public List<UnexpectedResponseExceptionDetail> getUnexpectedResponseExceptionDetails() {
        return this.unexpectedResponseExceptionDetails;
    }

    public void setUnexpectedResponseExceptionDetails(List<UnexpectedResponseExceptionDetail> unexpectedResponseExceptionDetails) {
        this.unexpectedResponseExceptionDetails = unexpectedResponseExceptionDetails;
    }
}

