/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.models;

import io.clientcore.annotation.processor.models.Substitution;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.utils.CoreUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public final class HttpRequestContext {
    private String methodName;
    private TypeMirror methodReturnType;
    private final List<MethodParameter> parameters;
    private HttpMethod httpMethod;
    private boolean isConvenience;
    private final LinkedHashSet<String> possibleUriParameterNames = new LinkedHashSet<String>(Arrays.asList("uri", "requestUri", "httpRequestUri"));
    private String uriParameterName = null;
    private boolean templateHasHost;
    private String host;
    private String path;
    private final Map<String, List<String>> headers;
    private final Map<String, QueryParameter> queryParams;
    private final Map<String, Substitution> substitutions;
    private int[] expectedStatusCodes;
    private TypeMirror defaultExceptionBodyType;
    private boolean isUriNextLink;
    private TypeMirror returnValueWireType;
    private Body body;
    private final Map<Integer, ExceptionBodyTypeInfo> exceptionBodyMappings = new HashMap<Integer, ExceptionBodyTypeInfo>();

    public HttpRequestContext() {
        this.parameters = new ArrayList<MethodParameter>();
        this.headers = new HashMap<String, List<String>>();
        this.queryParams = new LinkedHashMap<String, QueryParameter>();
        this.substitutions = new HashMap<String, Substitution>();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public TypeMirror getMethodReturnType() {
        return this.methodReturnType;
    }

    public void setMethodReturnType(TypeMirror methodReturnType) {
        this.methodReturnType = methodReturnType;
    }

    public void addParameter(MethodParameter parameter) {
        this.parameters.add(parameter);
        this.possibleUriParameterNames.remove(parameter.getName());
        if (this.possibleUriParameterNames.isEmpty()) {
            throw new IllegalStateException("The acceptable URI variable names weren't sufficient to prevent collision with parameter names of the method. File an issue on azure-sdk-for-java to expand the available choices to prevent conflicts.");
        }
    }

    public List<MethodParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getUriParameterName() {
        if (this.uriParameterName == null) {
            this.uriParameterName = (String)this.possibleUriParameterNames.iterator().next();
        }
        return this.uriParameterName;
    }

    public boolean isTemplateHasHost() {
        return this.templateHasHost;
    }

    public void setTemplateHasHost(boolean templateHasHost) {
        this.templateHasHost = templateHasHost;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, String value) {
        this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public Map<String, QueryParameter> getQueryParams() {
        return this.queryParams;
    }

    public void addQueryParam(String key, String value, boolean isMultiple, boolean shouldEncode, boolean isStatic) {
        QueryParameter existing = this.queryParams.get(key);
        if (existing != null) {
            existing.addValue(value);
        } else {
            this.queryParams.put(key, new QueryParameter(value, isMultiple, shouldEncode, isStatic));
        }
    }

    public void addSubstitution(Substitution substitution) {
        if (this.substitutions.containsKey(substitution.getParameterName())) {
            throw new IllegalArgumentException("Cannot add duplicate substitution for parameter '" + substitution.getParameterName() + "'");
        }
        this.substitutions.put(substitution.getParameterName(), substitution);
    }

    public Substitution getSubstitution(String parameterName) {
        return this.substitutions.get(parameterName);
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Body getBody() {
        return this.body;
    }

    public void setExpectedStatusCodes(int[] expectedStatusCodes) {
        if (expectedStatusCodes != null) {
            Arrays.sort(expectedStatusCodes);
        }
        this.expectedStatusCodes = expectedStatusCodes;
    }

    public List<Integer> getExpectedStatusCodes() {
        return Arrays.stream(this.expectedStatusCodes).boxed().collect(Collectors.toList());
    }

    public boolean isConvenience() {
        return this.isConvenience;
    }

    public void setIsConvenience(boolean isConvenience) {
        this.isConvenience = isConvenience;
    }

    public void addStaticHeaders(String[] headers) {
        if (CoreUtils.isNullOrEmpty((Object[])headers)) {
            return;
        }
        for (String header : headers) {
            String[] parts = header.split(":", 2);
            String key = parts[0].trim();
            String value = parts.length > 1 ? parts[1].trim() : "";
            List values = Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            this.headers.put(key, values);
        }
    }

    public void addStaticQueryParams(String[] queryParams) {
        if (CoreUtils.isNullOrEmpty((Object[])queryParams)) {
            return;
        }
        for (String queryParam : queryParams) {
            String[] parts = queryParam.split("=", 2);
            String key = parts[0].trim();
            String value = parts.length > 1 ? parts[1].trim() : null;
            this.addQueryParam(key, value, true, false, true);
        }
    }

    public void addExceptionBodyMapping(int statusCode, ExceptionBodyTypeInfo exceptionBodyClassName) {
        this.exceptionBodyMappings.put(statusCode, exceptionBodyClassName);
    }

    public Map<Integer, ExceptionBodyTypeInfo> getExceptionBodyMappings() {
        return this.exceptionBodyMappings;
    }

    public void setDefaultExceptionBodyType(TypeMirror type) {
        this.defaultExceptionBodyType = type;
    }

    public TypeMirror getDefaultExceptionBodyType() {
        return this.defaultExceptionBodyType;
    }

    public void setIsUriNextLink(boolean isUriNextLink) {
        this.isUriNextLink = isUriNextLink;
    }

    public boolean isUriNextLink() {
        return this.isUriNextLink;
    }

    public void setReturnValueWireType(TypeMirror returnValueWireType) {
        this.returnValueWireType = returnValueWireType;
    }

    public TypeMirror getReturnValueWireType() {
        return this.returnValueWireType;
    }

    public static class MethodParameter {
        private final TypeMirror type;
        private final String shortTypeName;
        private final String name;
        private final VariableElement variableElement;

        public MethodParameter(TypeMirror type, String shortTypeName, String name, VariableElement variableElement) {
            this.type = type;
            this.shortTypeName = shortTypeName;
            this.name = name;
            this.variableElement = variableElement;
        }

        public TypeMirror getTypeMirror() {
            return this.type;
        }

        public String getShortTypeName() {
            return this.shortTypeName;
        }

        public String getName() {
            return this.name;
        }

        public VariableElement getVariableElement() {
            return this.variableElement;
        }
    }

    public static class QueryParameter {
        private final List<String> values;
        private final boolean isMultiple;
        private final boolean shouldEncode;
        private final boolean isStatic;

        public QueryParameter(String value, boolean isMultiple, boolean shouldEncode, boolean isStatic) {
            this.values = new ArrayList<String>();
            this.values.add(value);
            this.isMultiple = isMultiple;
            this.shouldEncode = shouldEncode;
            this.isStatic = isStatic;
        }

        public QueryParameter(List<String> values, boolean isMultiple, boolean shouldEncode, boolean isStatic) {
            this.values = new ArrayList<String>(values);
            this.isMultiple = isMultiple;
            this.shouldEncode = shouldEncode;
            this.isStatic = isStatic;
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }

        public boolean shouldEncode() {
            return this.shouldEncode;
        }

        public boolean isStatic() {
            return this.isStatic;
        }
    }

    public static class Body {
        private final String contentType;
        private final TypeMirror parameterType;
        private final String parameterName;

        public Body(String contentType, TypeMirror parameterType, String parameterName) {
            this.contentType = contentType;
            this.parameterType = parameterType;
            this.parameterName = parameterName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public TypeMirror getParameterType() {
            return this.parameterType;
        }

        public String getParameterName() {
            return this.parameterName;
        }
    }

    public static class ExceptionBodyTypeInfo {
        private final TypeMirror typeMirror;
        private final boolean isDefaultObject;

        public ExceptionBodyTypeInfo(TypeMirror typeMirror, boolean isDefaultObject) {
            this.typeMirror = typeMirror;
            this.isDefaultObject = isDefaultObject;
        }

        public TypeMirror getTypeMirror() {
            return this.typeMirror;
        }

        public boolean isDefaultObject() {
            return this.isDefaultObject;
        }
    }
}

