/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.implementation.TypeUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class TypeConverter {
    public static Type toReflectType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: {
                return TypeConverter.handleDeclaredType(typeMirror);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return TypeConverter.getPrimitiveClass(typeMirror);
            }
            case VOID: {
                return Void.TYPE;
            }
            case ARRAY: {
                return TypeConverter.handleArrayType(typeMirror);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + typeMirror);
    }

    public static Class<?> getPrimitiveClass(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        return Object.class;
    }

    public static Type getEntityType(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case ARRAY: {
                return TypeConverter.handleArrayType(returnType);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return TypeConverter.getPrimitiveClass(returnType);
            }
            case DECLARED: {
                return TypeConverter.handleDeclaredType(returnType);
            }
        }
        return Object.class;
    }

    public static boolean isResponseType(TypeMirror returnType) {
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals(Response.class.getCanonicalName());
        }
        return false;
    }

    public static com.github.javaparser.ast.type.Type getAstType(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case VOID: {
                return StaticJavaParser.parseType((String)"void");
            }
            case BOOLEAN: {
                return StaticJavaParser.parseType((String)"boolean");
            }
            case BYTE: {
                return StaticJavaParser.parseType((String)"byte");
            }
            case SHORT: {
                return StaticJavaParser.parseType((String)"short");
            }
            case INT: {
                return StaticJavaParser.parseType((String)"int");
            }
            case LONG: {
                return StaticJavaParser.parseType((String)"long");
            }
            case CHAR: {
                return StaticJavaParser.parseType((String)"char");
            }
            case FLOAT: {
                return StaticJavaParser.parseType((String)"float");
            }
            case DOUBLE: {
                return StaticJavaParser.parseType((String)"double");
            }
            case ARRAY: {
                if (returnType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)returnType;
                    return StaticJavaParser.parseType((String)(TypeConverter.getAstType(arrayType.getComponentType()).toString() + "[]"));
                }
                return StaticJavaParser.parseType((String)"Object[]");
            }
            case DECLARED: {
                if (returnType instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)returnType;
                    TypeElement typeElement = (TypeElement)declaredType.asElement();
                    ClassOrInterfaceType astType = new ClassOrInterfaceType(null, typeElement.getSimpleName().toString());
                    if (!declaredType.getTypeArguments().isEmpty()) {
                        List typeArguments = declaredType.getTypeArguments().stream().map(TypeConverter::getAstType).collect(Collectors.toList());
                        NodeList nodeListTypeArguments = new NodeList(typeArguments);
                        astType.setTypeArguments(nodeListTypeArguments);
                    }
                    return astType;
                }
                return StaticJavaParser.parseType((String)"Object");
            }
        }
        throw new IllegalArgumentException("Unsupported return type: " + returnType);
    }

    static Type handleArrayType(TypeMirror type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type componentType = TypeConverter.toReflectType(arrayType.getComponentType());
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return Object.class;
    }

    static Type handleDeclaredType(TypeMirror declaredType) {
        ClassOrInterfaceType classType;
        if (declaredType instanceof ClassOrInterfaceType && (classType = (ClassOrInterfaceType)declaredType).getTypeArguments().isPresent()) {
            NodeList typeArguments = (NodeList)classType.getTypeArguments().get();
            if (!typeArguments.isEmpty()) {
                com.github.javaparser.ast.type.Type innerType = (com.github.javaparser.ast.type.Type)typeArguments.get(0);
                return TypeUtil.createParameterizedType(innerType.toString().getClass(), (Type[])new Type[0]);
            }
            return TypeConverter.toReflectType(declaredType);
        }
        return Object.class;
    }

    private TypeConverter() {
    }
}

