/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import io.clientcore.annotation.processor.exceptions.MissingSubstitutionException;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.models.Substitution;
import io.clientcore.core.implementation.AccessibleByteArrayOutputStream;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.utils.DateTimeRfc1123;
import io.clientcore.core.utils.ExpandableEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathBuilder {
    public static String buildPath(String rawPath, HttpRequestContext method) {
        long closingBracesCount;
        long openingBracesCount;
        String result;
        if (method == null) {
            throw new NullPointerException("method cannot be null");
        }
        Pattern pattern = Pattern.compile("\\{(.+?)}");
        Matcher matcher = pattern.matcher(rawPath);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String paramName = matcher.group(1);
            Substitution substitution = method.getSubstitution(paramName);
            if (substitution != null) {
                String substitutionValue = PathBuilder.serialize(JsonSerializer.getInstance(), substitution.getParameterVariableName());
                String replacementValue = substitution.shouldEncode() ? "UriEscapers.PATH_ESCAPER.escape(" + substitutionValue + ")" : (substitutionValue != null ? Objects.toString(substitutionValue, "null") : "");
                matcher.appendReplacement(buffer, "");
                if (buffer.length() != 0) {
                    buffer.append("\" + ");
                }
                buffer.append(replacementValue).append(" + \"");
                continue;
            }
            throw new MissingSubstitutionException("Could not find substitution for '" + paramName + "' in method '" + method.getMethodName() + "'");
        }
        matcher.appendTail(buffer);
        if (buffer.length() > 0 && buffer.charAt(0) != '\"' && !rawPath.startsWith("{")) {
            buffer.insert(0, '\"');
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '\"' && !rawPath.endsWith("}")) {
            buffer.append('\"');
        }
        if ((result = buffer.toString().replaceAll(" \\+ \"\"", "")).endsWith(" + ")) {
            result = result.substring(0, result.length() - 3);
        }
        if (result.endsWith(" + \"")) {
            result = result.substring(0, result.length() - 4);
        }
        if ((openingBracesCount = rawPath.chars().filter(ch -> ch == 123).count()) != (closingBracesCount = rawPath.chars().filter(ch -> ch == 125).count())) {
            throw new MissingSubstitutionException("Mismatched braces in raw host: " + rawPath);
        }
        return result;
    }

    private static String serialize(JsonSerializer serializer, Object value) {
        String string;
        if (value == null) {
            return null;
        }
        if (value instanceof ExpandableEnum) {
            value = PathBuilder.serialize(serializer, ((ExpandableEnum)value).getValue());
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof DateTimeRfc1123) {
            return String.valueOf(value);
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_INSTANT);
        }
        AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();
        try {
            serializer.serializeToStream((OutputStream)outputStream, value);
            string = outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return string;
    }

    private PathBuilder() {
    }
}

