/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.templating;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.models.TemplateInput;
import io.clientcore.annotation.processor.templating.TemplateProcessor;
import io.clientcore.annotation.processor.utils.RequestBodyHandler;
import io.clientcore.annotation.processor.utils.ResponseHandler;
import io.clientcore.annotation.processor.utils.TypeConverter;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.implementation.utils.UriEscapers;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.xml.XmlSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class JavaParserTemplateProcessor
implements TemplateProcessor {
    private static final Map<String, String> LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT = new HashMap<String, String>();
    private final CompilationUnit compilationUnit = new CompilationUnit();
    private ClassOrInterfaceDeclaration classBuilder;

    @Override
    public void process(TemplateInput templateInput, ProcessingEnvironment processingEnv) {
        String packageName = templateInput.getPackageName();
        packageName = packageName.substring(0, packageName.lastIndexOf(46));
        String serviceInterfaceImplShortName = templateInput.getServiceInterfaceImplShortName();
        String serviceInterfaceShortName = templateInput.getServiceInterfaceShortName();
        this.addImports(templateInput);
        this.addCopyrightComments();
        this.setPackageDeclaration(packageName);
        this.createClass(serviceInterfaceImplShortName, serviceInterfaceShortName, templateInput, processingEnv);
        this.writeFile(packageName, serviceInterfaceImplShortName, processingEnv);
    }

    void addImports(TemplateInput templateInput) {
        templateInput.getImports().keySet().forEach(arg_0 -> ((CompilationUnit)this.compilationUnit).addImport(arg_0));
    }

    void addCopyrightComments() {
        this.compilationUnit.addOrphanComment((Comment)new LineComment(" Copyright (c) Microsoft Corporation. All rights reserved."));
        this.compilationUnit.addOrphanComment((Comment)new LineComment(" Licensed under the MIT License."));
    }

    void setPackageDeclaration(String packageName) {
        this.compilationUnit.setPackageDeclaration(packageName);
    }

    void createClass(String serviceInterfaceImplShortName, String serviceInterfaceShortName, TemplateInput templateInput, ProcessingEnvironment processingEnv) {
        this.classBuilder = this.compilationUnit.addClass(serviceInterfaceImplShortName, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        this.classBuilder.setJavadocComment("Initializes a new instance of the " + serviceInterfaceImplShortName + " type.");
        String serviceInterfacePackage = templateInput.getServiceInterfaceFQN().substring(0, templateInput.getServiceInterfaceFQN().lastIndexOf(46));
        this.compilationUnit.addImport(serviceInterfacePackage + "." + serviceInterfaceShortName);
        this.classBuilder.addImplementedType(serviceInterfaceShortName);
        this.addLoggerField(serviceInterfaceShortName);
        this.addHttpPipelineField();
        this.addSerializerFields();
        this.addConstructor();
        this.addGetNewInstanceMethod(serviceInterfaceImplShortName, serviceInterfaceShortName);
        for (HttpRequestContext method : templateInput.getHttpRequestContexts()) {
            if (method.isConvenience()) continue;
            this.configureInternalMethod(this.classBuilder.addMethod(method.getMethodName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}), method, processingEnv);
        }
        this.addDeserializeHelperMethod(this.classBuilder.addMethod("decodeNetworkResponse", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC}));
    }

    private void addLoggerField(String serviceInterfaceShortName) {
        this.configureLoggerField(this.classBuilder.addField("ClientLogger", "LOGGER", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL}), serviceInterfaceShortName);
    }

    private void addHttpPipelineField() {
        this.classBuilder.addField(HttpPipeline.class, "httpPipeline", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
    }

    private void addSerializerFields() {
        this.compilationUnit.addImport(JsonSerializer.class);
        this.classBuilder.addField(JsonSerializer.class, "jsonSerializer", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        this.compilationUnit.addImport(XmlSerializer.class);
        this.classBuilder.addField(XmlSerializer.class, "xmlSerializer", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
    }

    private void addConstructor() {
        ((ConstructorDeclaration)this.classBuilder.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE}).addParameter(HttpPipeline.class, "httpPipeline")).setBody(StaticJavaParser.parseBlock((String)"{ this.httpPipeline = httpPipeline; this.jsonSerializer = JsonSerializer.getInstance(); this.xmlSerializer = XmlSerializer.getInstance(); }"));
    }

    private void addGetNewInstanceMethod(String serviceInterfaceImplShortName, String serviceInterfaceShortName) {
        ((MethodDeclaration)((MethodDeclaration)this.classBuilder.addMethod("getNewInstance", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).setType(serviceInterfaceShortName)).addParameter(HttpPipeline.class, "httpPipeline")).setBody(StaticJavaParser.parseBlock((String)("{ return new " + serviceInterfaceImplShortName + "(httpPipeline); }"))).setJavadocComment("Creates an instance of " + serviceInterfaceShortName + " that is capable of sending requests to the service.\n@param httpPipeline The HTTP pipeline to use for sending requests.\n@return An instance of `" + serviceInterfaceShortName + "`;");
    }

    CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    private void addDeserializeHelperMethod(MethodDeclaration deserializeHelperMethod) {
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)deserializeHelperMethod.setType("Object")).addParameter("BinaryData", "data")).addParameter(ObjectSerializer.class, "serializer")).addParameter("ParameterizedType", "returnType");
        deserializeHelperMethod.tryAddImportToParentCompilationUnit(IOException.class);
        deserializeHelperMethod.tryAddImportToParentCompilationUnit(UncheckedIOException.class);
        deserializeHelperMethod.tryAddImportToParentCompilationUnit(ParameterizedType.class);
        deserializeHelperMethod.tryAddImportToParentCompilationUnit(Type.class);
        deserializeHelperMethod.tryAddImportToParentCompilationUnit(List.class);
        deserializeHelperMethod.setJavadocComment("Decodes the body of an {@link Response} into the type returned by the called API.\n@param data The BinaryData to decode.\n@param serializer The serializer to use.\n@param returnType The type of the ParameterizedType return value.\n@return The decoded value.\n@throws IOException If the deserialization fails.");
        deserializeHelperMethod.setBody((BlockStmt)((BlockStmt)new BlockStmt().addStatement(StaticJavaParser.parseStatement((String)"if (data == null) { return null; }"))).addStatement(StaticJavaParser.parseStatement((String)"try { if (List.class.isAssignableFrom((Class<?>) returnType.getRawType())) {  return serializer.deserializeFromBytes(data.toBytes(), returnType); } Type token = returnType.getRawType(); if (Response.class.isAssignableFrom((Class<?>) token)) {  token = returnType.getActualTypeArguments()[0]; } return serializer.deserializeFromBytes(data.toBytes(), token); } catch (IOException e) {     throw LOGGER.logThrowableAsError(new UncheckedIOException(e)); }")));
    }

    void configureLoggerField(FieldDeclaration field, String serviceInterfaceShortName) {
        field.tryAddImportToParentCompilationUnit(ClientLogger.class);
        ((FieldDeclaration)field.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL})).setVariables(new NodeList((Node[])new VariableDeclarator[]{((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType("ClientLogger")).setName("LOGGER")).setInitializer("new ClientLogger(" + serviceInterfaceShortName + ".class)")}));
    }

    private void configureInternalMethod(MethodDeclaration internalMethod, HttpRequestContext method, ProcessingEnvironment processingEnv) {
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)internalMethod.setName(method.getMethodName())).addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("SuppressWarnings"), (Expression)new ArrayInitializerExpr(new NodeList((Node[])new Expression[]{new StringLiteralExpr("unchecked"), new StringLiteralExpr("cast")}))))).addMarkerAnnotation(Override.class)).setType(TypeConverter.getAstType(method.getMethodReturnType()));
        method.getParameters().forEach(param -> internalMethod.addParameter(new Parameter(StaticJavaParser.parseType((String)param.getShortTypeName()), param.getName())));
        BlockStmt body = (BlockStmt)internalMethod.getBody().get();
        this.initializeHttpRequest(body, method);
        this.setContentType(body, method);
        boolean serializationFormatSet = RequestBodyHandler.configureRequestBody(body, method.getBody(), processingEnv);
        this.addRequestContextToRequestIfPresent(body, method);
        this.finalizeHttpRequest(body, method.getMethodReturnType(), method, serializationFormatSet);
        internalMethod.setBody(body);
    }

    private void setContentType(BlockStmt body, HttpRequestContext method) {
        HttpRequestContext.Body requestBody = method.getBody();
        if (requestBody == null || requestBody.getParameterType() == null) {
            return;
        }
        boolean isContentTypeSetInHeaders = method.getParameters().stream().anyMatch(p -> "contentType".equals(p.getName()));
        if (!isContentTypeSetInHeaders) {
            String contentType = requestBody.getContentType();
            RequestBodyHandler.setContentTypeHeader(body, contentType);
        }
    }

    private void writeFile(String packageName, String serviceInterfaceImplShortName, ProcessingEnvironment processingEnv) {
        try (Writer fileWriter = processingEnv.getFiler().createSourceFile(packageName + "." + serviceInterfaceImplShortName, new Element[0]).openWriter();){
            fileWriter.write(this.compilationUnit.toString());
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addRequestContextToRequestIfPresent(BlockStmt body, HttpRequestContext method) {
        boolean hasRequestContext = method.getParameters().stream().anyMatch(parameter -> "requestContext".equals(parameter.getName()) && "RequestContext".equals(parameter.getShortTypeName()));
        if (hasRequestContext) {
            Statement statement1 = StaticJavaParser.parseStatement((String)"httpRequest.setContext(requestContext);");
            Statement statement2 = StaticJavaParser.parseStatement((String)"httpRequest.getContext().getRequestCallback().accept(httpRequest);");
            body.addStatement(statement1);
            body.addStatement(statement2);
        }
    }

    void initializeHttpRequest(BlockStmt body, HttpRequestContext method) {
        body.tryAddImportToParentCompilationUnit(HttpRequest.class);
        body.tryAddImportToParentCompilationUnit(HttpMethod.class);
        boolean useProvidedUri = method.getParameters().stream().anyMatch(parameter -> "uri".equals(parameter.getName()) && "String".equals(parameter.getShortTypeName()));
        body.tryAddImportToParentCompilationUnit(UriEscapers.class);
        String urlStatement = useProvidedUri ? String.format("String url = uri + \"/\" + %s;", method.getHost()) : String.format("String url = %s;", method.getHost());
        body.addStatement(StaticJavaParser.parseStatement((String)urlStatement));
        this.appendQueryParams(body, method);
        Statement statement = StaticJavaParser.parseStatement((String)("HttpRequest httpRequest = new HttpRequest().setMethod(HttpMethod." + method.getHttpMethod() + ").setUri(url);"));
        statement.setLineComment("\n Create the HTTP request");
        body.addStatement(statement);
        this.addHeadersToRequest(body, method);
    }

    private void appendQueryParams(BlockStmt body, HttpRequestContext method) {
        if (!method.getQueryParams().isEmpty()) {
            Statement newUrlDeclaration = StaticJavaParser.parseStatement((String)"String newUrl;");
            newUrlDeclaration.setComment((Comment)new LineComment("\n Append non-null query parameters"));
            body.addStatement(newUrlDeclaration);
            body.tryAddImportToParentCompilationUnit(LinkedHashMap.class);
            body.addStatement("LinkedHashMap<String, Object> queryParamMap = new LinkedHashMap<>();");
            method.getQueryParams().entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                HttpRequestContext.QueryParameter value = (HttpRequestContext.QueryParameter)entry.getValue();
                boolean isValueTypeString = method.getParameters().stream().anyMatch(parameter -> parameter.getName().equals(value.getValue()) && "String".equals(parameter.getShortTypeName()));
                if (value.shouldEncode()) {
                    if (isValueTypeString) {
                        String encodedKey = "UriEscapers.QUERY_ESCAPER.escape(\"" + key + "\")";
                        String encodedValue = "UriEscapers.QUERY_ESCAPER.escape(" + value.getValue() + ")";
                        body.addStatement("queryParamMap.put(" + encodedKey + ", " + encodedValue + ");");
                    } else {
                        body.addStatement("queryParamMap.put(\"" + key + "\", " + value.getValue() + ");");
                    }
                } else {
                    body.addStatement("queryParamMap.put(\"" + key + "\", " + value.getValue() + ");");
                }
            });
            body.addStatement("newUrl = CoreUtils.appendQueryParams(url, queryParamMap);");
            body.addStatement("if (newUrl != null) { url = newUrl; }");
        }
    }

    private void addHeadersToRequest(BlockStmt body, HttpRequestContext method) {
        if (method.getHeaders().isEmpty()) {
            return;
        }
        body.tryAddImportToParentCompilationUnit(HttpHeaderName.class);
        StringBuilder httpRequestBuilder = new StringBuilder("httpRequest.getHeaders()");
        for (Map.Entry<String, String> header : method.getHeaders().entrySet()) {
            boolean isStringType = method.getParameters().stream().anyMatch(parameter -> parameter.getName().equals(header.getValue()) && "String".equals(parameter.getShortTypeName()));
            String value = isStringType ? header.getValue() : "String.valueOf(" + header.getValue() + ")";
            String constantName = LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT.get(header.getKey().toLowerCase(Locale.ROOT));
            if (constantName != null) {
                httpRequestBuilder.append(".add(HttpHeaderName.").append(constantName).append(", ").append(value).append(")");
                continue;
            }
            httpRequestBuilder.append(".add(HttpHeaderName.fromString(\"").append(header.getKey()).append("\"), ").append(value).append(")");
        }
        body.addStatement(StaticJavaParser.parseStatement((String)(httpRequestBuilder + ";")));
    }

    private void finalizeHttpRequest(BlockStmt body, TypeMirror returnTypeName, HttpRequestContext method, boolean serializationFormatSet) {
        body.tryAddImportToParentCompilationUnit(Response.class);
        Statement statement = StaticJavaParser.parseStatement((String)"Response<BinaryData> networkResponse = this.httpPipeline.send(httpRequest);");
        statement.setLineComment("\n Send the request through the httpPipeline");
        body.addStatement(statement);
        if (!method.getExpectedStatusCodes().isEmpty()) {
            this.validateResponseStatus(body, method);
        }
        ResponseHandler.generateResponseHandling(body, returnTypeName, method, serializationFormatSet);
    }

    private void validateResponseStatus(BlockStmt body, HttpRequestContext method) {
        String expectedResponseCheck;
        if (method.getExpectedStatusCodes().isEmpty()) {
            return;
        }
        body.addStatement(StaticJavaParser.parseStatement((String)"int responseCode = networkResponse.getStatusCode();"));
        if (method.getExpectedStatusCodes().size() == 1) {
            expectedResponseCheck = "responseCode == " + method.getExpectedStatusCodes().get(0) + ";";
        } else {
            String statusCodes = method.getExpectedStatusCodes().stream().map(code -> "responseCode == " + code).collect(Collectors.joining(" || "));
            expectedResponseCheck = "(" + statusCodes + ");";
        }
        body.addStatement(StaticJavaParser.parseStatement((String)("boolean expectedResponse = " + expectedResponseCheck)));
        body.tryAddImportToParentCompilationUnit(RuntimeException.class);
        body.addStatement(StaticJavaParser.parseStatement((String)"if (!expectedResponse) { throw new RuntimeException(\"Unexpected response code: \" + responseCode); }"));
    }

    static {
        for (Field field : HttpHeaderName.class.getDeclaredFields()) {
            HttpHeaderName httpHeaderName;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            String constantName = field.getName();
            try {
                httpHeaderName = (HttpHeaderName)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            LOWERCASE_HEADER_TO_HTTPHEADENAME_CONSTANT.put(httpHeaderName.getCaseInsensitiveName(), constantName);
        }
    }
}

