/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.logging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class JsonLogMessage {
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonLogMessage() {
    }

    public static QueryLog queryLog() {
        return new QueryLog();
    }

    public static SuggestionLog suggestionLog() {
        return new SuggestionLog();
    }

    public static IndexLog indexLog() {
        return new IndexLog();
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static class IndexLog
    extends Log {
        private Map<String, Map> stats = new HashMap<String, Map>();

        @Override
        public String getType() {
            return "index";
        }

        @JsonProperty(value="stats")
        public Object getStats() {
            return this.stats;
        }

        @Override
        public IndexLog setClient(String collection) {
            super.setClient(collection);
            return this;
        }

        public IndexLog setStats(Map<String, Object> stats) {
            for (Map.Entry<String, Object> entry : stats.entrySet()) {
                this.stats.put(entry.getKey(), Collections.singletonMap("count", ((NamedList)entry.getValue()).get("count")));
            }
            return this;
        }
    }

    public static class QueryLog
    extends Log {
        private Map<String, Object> query = new HashMap<String, Object>();

        public QueryLog() {
            this.query.put("resultsize", new HashMap());
        }

        @Override
        public String getType() {
            return "query";
        }

        @Override
        public QueryLog setClient(String collection) {
            super.setClient(collection);
            return this;
        }

        @JsonProperty(value="query")
        public Map<String, Object> getQuery() {
            return this.query;
        }

        public QueryLog setQueryTime(long querytime) {
            this.query.put("querytime", querytime);
            return this;
        }

        public QueryLog setResultSize(String type, long resultSize) {
            ((Map)this.query.get("resultsize")).put(type, resultSize);
            return this;
        }

        public QueryLog setSearchTerm(String searchTerm) {
            this.query.put("searchterm", searchTerm);
            return this;
        }
    }

    public static class SuggestionLog
    extends Log {
        private Map<String, Object> query = new HashMap<String, Object>();

        @Override
        public String getType() {
            return "suggestion";
        }

        @JsonProperty(value="query")
        public Map<String, Object> getQuery() {
            return this.query;
        }

        public SuggestionLog setQueryTime(long querytime) {
            this.query.put("querytime", querytime);
            return this;
        }

        public SuggestionLog setSearchTerm(String searchTerm) {
            this.query.put("searchterm", searchTerm);
            return this;
        }

        @Override
        public SuggestionLog setClient(String collection) {
            super.setClient(collection);
            return this;
        }
    }

    public static abstract class Log {
        @JsonProperty(value="client")
        public Client client;

        @JsonProperty(value="type")
        public abstract String getType();

        public Log setClient(String collection) {
            this.client = new Client(collection);
            return this;
        }

        @JsonIgnore
        public String toJsonString() throws JsonProcessingException {
            return mapper.writeValueAsString((Object)this);
        }

        public static class Client {
            private String collection;

            protected Client(String collection) {
                this.collection = collection;
            }

            public String getCollection() {
                return this.collection;
            }

            public void setCollection(String collection) {
                this.collection = collection;
            }
        }
    }
}

