/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import io.chatpal.solr.ext.ChatpalApiConfig;
import io.chatpal.solr.ext.DocType;
import io.chatpal.solr.ext.logging.JsonLogMessage;
import io.chatpal.solr.ext.logging.ReportingLogger;
import java.util.HashMap;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.PingRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatpalPingRequestHandler
extends PingRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ChatpalPingRequestHandler.class);
    private ReportingLogger reporting = ReportingLogger.getInstance();
    private static final String PARAM_STATS = "stats";
    private static final String PARAM_CONFIG = "config";
    private static final String PARAM_SCHEMA_VERSION = "schemaVersion";
    private static final String VALUE_NEWEST = "newest";
    private static final String VALUE_OLDEST = "oldest";
    private static final String FIELD_AGE = "created";
    private ChatpalApiConfig apiConfig = new ChatpalApiConfig();

    public void inform(SolrCore core) {
        super.inform(core);
        this.apiConfig = ChatpalApiConfig.fromSolrConfig(core.getSolrConfig());
        LOG.info("Loaded api-config: {}", (Object)this.apiConfig);
    }

    protected void handlePing(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        super.handlePing(req, rsp);
        if (req.getParams().getBool(PARAM_SCHEMA_VERSION, true)) {
            IndexSchema indexSchema = req.getSchema();
            rsp.add(PARAM_SCHEMA_VERSION, (Object)Float.valueOf(indexSchema.getVersion()));
        }
        if (req.getParams().getBool(PARAM_STATS, false)) {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            if (this.apiConfig.getGeneralSearch().isEnabled()) {
                stats.put(DocType.Message.getKey(), this.getStats(DocType.Message, req));
                stats.put(DocType.Room.getKey(), this.getStats(DocType.Room, req));
                stats.put(DocType.User.getKey(), this.getStats(DocType.User, req));
            }
            if (this.apiConfig.getFileSearch().isEnabled()) {
                stats.put(DocType.File.getKey(), this.getStats(DocType.File, req));
            }
            rsp.add(PARAM_STATS, stats);
            this.reporting.logPing(JsonLogMessage.indexLog().setClient(req.getCore().getName()).setStats(stats));
        }
        if (req.getParams().getBool(PARAM_CONFIG, true)) {
            rsp.add(PARAM_CONFIG, (Object)this.apiConfig);
        }
    }

    private Object getStats(DocType type, SolrQueryRequest req) {
        ModifiableSolrParams query = new ModifiableSolrParams();
        query.set("q", new String[]{"*:*"});
        query.set("rows", 0);
        query.set("fq", new String[]{"type:" + type.getIndexVal()});
        query.set("json.facet", new String[]{String.format("{%s:'min(%s)', %s:'max(%s)'}", VALUE_OLDEST, FIELD_AGE, VALUE_NEWEST, FIELD_AGE)});
        try (LocalSolrQueryRequest localRequest = new LocalSolrQueryRequest(req.getCore(), (SolrParams)query);){
            SolrQueryResponse response = new SolrQueryResponse();
            req.getCore().getRequestHandler(null).handleRequest((SolrQueryRequest)localRequest, response);
            Object object = response.getValues().get("facets");
            return object;
        }
    }
}

