/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext;

import io.chatpal.solr.ext.util.SolrConfigUtils;
import java.util.Map;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;

public class ChatpalApiConfig
implements MapSerializable {
    private static final String XML_ROOT = "/config/chatpal/";
    private Search generalSearch = new Search();
    private FileSearch fileSearch = new FileSearch();

    public Search getGeneralSearch() {
        return this.generalSearch;
    }

    public FileSearch getFileSearch() {
        return this.fileSearch;
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        map.put("generalSearch", this.generalSearch);
        map.put("fileSearch", this.fileSearch);
        return map;
    }

    public String toString() {
        return "ChatpalApiConfig{" + this.generalSearch + ", " + this.fileSearch + '}';
    }

    public static ChatpalApiConfig fromSolrConfig(SolrConfig solrConfig) {
        ChatpalApiConfig chatpal = new ChatpalApiConfig();
        chatpal.generalSearch.enabled = solrConfig.getBool("/config/chatpal/generalSearch/enabled", true);
        chatpal.fileSearch.enabled = solrConfig.getBool("/config/chatpal/fileSearch/enabled", false);
        chatpal.fileSearch.maxFileSize = SolrConfigUtils.getLong((Config)solrConfig, "/config/chatpal/fileSearch/maxFileSize", Math.round(20.0 * Math.pow(1024.0, 2.0)));
        return chatpal;
    }

    public static class FileSearch
    extends Search {
        protected long maxFileSize = Math.round(20.0 * Math.pow(1024.0, 2.0));

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        @Override
        public Map<String, Object> toMap(Map<String, Object> map) {
            super.toMap(map);
            map.put("maxFileSize", this.maxFileSize);
            return map;
        }
    }

    public static class Search
    implements MapSerializable {
        protected boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Map<String, Object> toMap(Map<String, Object> map) {
            map.put("enabled", this.enabled);
            return map;
        }

        public String toString() {
            return String.format("%s{enabled=%s}", this.getClass().getSimpleName(), this.enabled);
        }
    }
}

