/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import com.google.common.collect.ImmutableMap;
import io.chatpal.solr.ext.handler.QueryHelper;
import io.chatpal.solr.ext.logging.JsonLogMessage;
import io.chatpal.solr.ext.logging.ReportingLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestionRequestHandler
extends SearchHandler {
    private static final int DEFAULT_SUGGESTION_SIZE = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(SuggestionRequestHandler.class);
    private ReportingLogger reporting = ReportingLogger.getInstance();
    private int suggestionsSize = 10;

    public void init(NamedList args) {
        super.init(args);
        if (args != null) {
            Object size = args.get("suggestions.size");
            this.suggestionsSize = NumberUtils.toInt((String)String.valueOf(size), (int)10);
            if (this.suggestionsSize <= 0) {
                LOGGER.warn("Configured {} is less than 1, falling back to default {}", (Object)"suggestions.size", (Object)10);
                this.suggestionsSize = 10;
            }
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        long start = System.currentTimeMillis();
        String text = req.getParams().get("text");
        if (StringUtils.isEmpty((CharSequence)text)) {
            rsp.getValues().add("suggestion", Collections.emptyList());
            return;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", new String[]{"*:*"});
        params.set("rows", 0);
        params.set("facet", true);
        params.set("facet.field", new String[]{"suggestion"});
        params.set("facet.mincount", 1);
        params.set("facet.limit", 15);
        String[] typeParams = req.getParams().getParams("type[]");
        if (typeParams != null) {
            params.add("fq", new String[]{QueryHelper.buildTermsQuery("type", typeParams)});
        }
        List<String> tokens = Stream.of(text.split("\\s+")).map(String::toLowerCase).collect(Collectors.toList());
        text = text.endsWith(" ") ? null : (String)tokens.remove(tokens.size() - 1);
        tokens.forEach(t -> params.add("fq", new String[]{"suggestion:" + t}));
        params.set("facet.prefix", new String[]{text});
        this.appendACLFilter(params, req);
        try (LocalSolrQueryRequest userRequest = new LocalSolrQueryRequest(req.getCore(), (SolrParams)params);){
            SolrQueryResponse response = new SolrQueryResponse();
            super.handleRequestBody((SolrQueryRequest)userRequest, response);
            Iterator entries = ((NamedList)((SimpleOrderedMap)((SimpleOrderedMap)response.getValues().get("facet_counts")).get("facet_fields")).get("suggestion")).iterator();
            ArrayList<ImmutableMap> suggestions = new ArrayList<ImmutableMap>();
            String prefix = String.join((CharSequence)" ", tokens);
            if (prefix.length() > 0) {
                prefix = prefix + " ";
            }
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                if (!tokens.contains(entry.getKey())) {
                    suggestions.add(ImmutableMap.of((Object)"text", (Object)(prefix + (String)entry.getKey()), (Object)"count", entry.getValue()));
                }
                if (suggestions.size() < this.suggestionsSize) continue;
                break;
            }
            rsp.getValues().add("suggestion", suggestions);
            this.reporting.logSuggestion(JsonLogMessage.suggestionLog().setClient(req.getCore().getName()).setSearchTerm(text).setQueryTime(System.currentTimeMillis() - start));
        }
    }

    private void appendACLFilter(ModifiableSolrParams query, SolrQueryRequest req) {
        query.add("fq", new String[]{this.buildACLFilter(req.getParams())});
    }

    private String buildACLFilter(SolrParams params) {
        return QueryHelper.buildTermsQuery("rid", params.getParams("acl[]"));
    }
}

