/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;

public class QueryHelper {
    private QueryHelper() {
    }

    public static String buildTermsQuery(String field, String[] values) {
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL nor blank");
        }
        if (values == null) {
            values = new String[]{};
        }
        return String.format("{!terms f=%s}", field) + Arrays.stream(values).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
    }

    public static String buildOrFilter(String field, String[] values) {
        if (values == null || values.length < 1) {
            if (StringUtils.isBlank((CharSequence)field)) {
                return "-[* TO *]";
            }
            return "-" + field + ":*";
        }
        return "{!q.op=OR}" + (StringUtils.isBlank((CharSequence)field) ? "" : field + ":") + Arrays.stream(values).filter(StringUtils::isNotBlank).map(ClientUtils::escapeQueryChars).collect(Collectors.joining(" ", "(", ")"));
    }

    public static String cleanTextQuery(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&' || c == '?' || c == ';' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

