/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import io.chatpal.solr.ext.DocType;
import io.chatpal.solr.ext.handler.QueryHelper;
import io.chatpal.solr.ext.logging.JsonLogMessage;
import io.chatpal.solr.ext.logging.ReportingLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatpalSearchRequestHandler
extends SearchHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatpalSearchRequestHandler.class);
    private ReportingLogger reporting = ReportingLogger.getInstance();
    private Map<DocType, SolrParams> defaultParams = new EnumMap<DocType, SolrParams>(DocType.class);

    public void init(NamedList args) {
        super.init(args);
        if (args != null) {
            for (DocType docType : DocType.values()) {
                this.defaultParams.put(docType, ChatpalSearchRequestHandler.getSolrParamsFromNamedList((NamedList)args, (String)docType.getKey()));
            }
        }
    }

    public void handleRequestBody(SolrQueryRequest originalReq, SolrQueryResponse rsp) throws Exception {
        long start = System.currentTimeMillis();
        Loggable msgLog = this.queryFor(DocType.Message, originalReq, rsp, this::setLanguageConfig, this::setTimeRegressionBoost, this::appendACLFilter, this::appendExclusionFilter);
        Loggable fileLog = this.queryFor(DocType.File, originalReq, rsp, this::setTimeRegressionBoost, this::appendACLFilter, this::appendExclusionFilter);
        Loggable roomLog = this.queryFor(DocType.Room, originalReq, rsp, this::appendACLFilter, this::appendExclusionFilter);
        Loggable userLog = this.queryFor(DocType.User, originalReq, rsp, new QueryAdapter[0]);
        JsonLogMessage.QueryLog log = JsonLogMessage.queryLog().setClient(originalReq.getCore().getName()).setSearchTerm(originalReq.getParams().get("text"));
        if (msgLog != null) {
            log.setResultSize(DocType.Message.getKey(), msgLog.numFound);
        }
        if (fileLog != null) {
            log.setResultSize(DocType.File.getKey(), fileLog.numFound);
        }
        if (roomLog != null) {
            log.setResultSize(DocType.Room.getKey(), roomLog.numFound);
        }
        if (userLog != null) {
            log.setResultSize(DocType.User.getKey(), userLog.numFound);
        }
        log.setQueryTime(System.currentTimeMillis() - start);
        this.reporting.logQuery(log);
    }

    private Loggable queryFor(DocType docType, SolrQueryRequest req, SolrQueryResponse rsp, QueryAdapter ... queryAdapter) throws Exception {
        if (!this.typeFilterAccepts(req, docType)) {
            return null;
        }
        ModifiableSolrParams query = new ModifiableSolrParams();
        String language = req.getParams().get("language", "none");
        String q = req.getParams().get("query");
        if (q != null) {
            query.set("defType", new String[]{"lucene"});
            query.set("q", new String[]{q});
        } else {
            query.set("q", new String[]{QueryHelper.cleanTextQuery(req.getParams().get("text"))});
        }
        query.set("sort", new String[]{req.getParams().get("sort")});
        query.set("fq", new String[]{this.buildTypeFilter(docType)});
        query.set("start", new String[]{req.getParams().get(this.buildTypeParam(docType, "start"), req.getParams().get("start"))});
        query.set("rows", new String[]{req.getParams().get(this.buildTypeParam(docType, "rows"), req.getParams().get("rows"))});
        for (QueryAdapter adapter : queryAdapter) {
            adapter.adaptQuery(query, req, rsp, docType);
        }
        ModifiableSolrParams appendedParams = new ModifiableSolrParams();
        if (req.getSchema().getUniqueKeyField() != null) {
            appendedParams.add("fl", new String[]{req.getSchema().getUniqueKeyField().getName()});
        }
        SolrParams defaultedQuery = SolrParams.wrapAppended((SolrParams)SolrParams.wrapDefaults((SolrParams)query, (SolrParams)SolrParams.wrapDefaults((SolrParams)this.defaultParams.get((Object)docType), (SolrParams)this.defaults)), (SolrParams)appendedParams);
        LOGGER.debug("Chatpal query: {}", (Object)defaultedQuery);
        try (LocalSolrQueryRequest subRequest = new LocalSolrQueryRequest(req.getCore(), defaultedQuery);){
            SolrQueryResponse response = new SolrQueryResponse();
            super.handleRequestBody((SolrQueryRequest)subRequest, response);
            rsp.add(docType.getKey(), (Object)this.materializeResult(req.getSchema(), response, language));
            Loggable loggable = new Loggable(((ResultContext)response.getResponse()).getDocList().matches());
            return loggable;
        }
    }

    private void setLanguageConfig(ModifiableSolrParams query, SolrQueryRequest req, SolrQueryResponse rsp, DocType docType) {
        String language = req.getParams().get("language", "none");
        if (this.isParamSet(req, "query")) {
            query.set("df", new String[]{"text_" + language});
        } else {
            query.set("qf", new String[]{"context^2 text_${lang}^1 decompose_text_${lang}^.5".replaceAll("\\$\\{lang}", language)});
            query.add("hl.fl", new String[]{"text_${lang}".replaceAll("\\$\\{lang}", language)});
        }
    }

    private void setTimeRegressionBoost(ModifiableSolrParams query, SolrQueryRequest req, SolrQueryResponse rsp, DocType docType) {
        if (!this.isParamSet(req, "query")) {
            query.set("bf", new String[]{"recip(ms(NOW,updated),3.6e-11,3,1)"});
        }
    }

    private boolean isParamSet(SolrQueryRequest req, String param) {
        return req.getParams().get(param) != null;
    }

    private boolean typeFilterAccepts(SolrQueryRequest req, DocType type) {
        Object[] types = req.getParams().getParams("type[]");
        return ArrayUtils.isEmpty((Object[])types) || ArrayUtils.contains((Object[])types, (Object)type.getKey());
    }

    private NamedList materializeResult(IndexSchema schema, SolrQueryResponse rsp, String language) {
        NamedList facets;
        NamedList result = new NamedList();
        ResultContext rspContext = (ResultContext)rsp.getResponse();
        DocList docList = rspContext.getDocList();
        ArrayList<SolrDocument> docs = new ArrayList<SolrDocument>(docList.size());
        NamedList highlighting = (NamedList)rsp.getValues().get("highlighting");
        DocsStreamer documentIterator = new DocsStreamer(rspContext);
        while (documentIterator.hasNext()) {
            SolrDocument doc = documentIterator.next();
            this.inlineHighlighting(doc, (NamedList<NamedList<Object>>)highlighting, rspContext, schema, language);
            for (String fName : new HashSet(doc.getFieldNames())) {
                if (rspContext.getReturnFields().wantsField(fName)) continue;
                doc.removeFields(fName);
            }
            doc.removeFields(schema.getUniqueKeyField().getName());
            docs.add(doc);
        }
        result.add("docs", docs);
        result.add("numFound", (Object)docList.matches());
        result.add("start", (Object)docList.offset());
        if (docList.hasScores()) {
            result.add("maxScore", (Object)Float.valueOf(docList.maxScore()));
        }
        if ((facets = (NamedList)rsp.getValues().get("facet_counts")) != null) {
            result.add("facets", (Object)facets);
        }
        return result;
    }

    private void inlineHighlighting(SolrDocument doc, NamedList<NamedList<Object>> highlighting, ResultContext rspContext, IndexSchema schema, String language) {
        if (highlighting == null) {
            return;
        }
        String id = String.valueOf(this.getFirstValue(doc, schema.getUniqueKeyField()));
        NamedList highlights = (NamedList)highlighting.get(id);
        if (highlights == null) {
            return;
        }
        for (Map.Entry highlight : highlights) {
            String fieldName = (String)highlight.getKey();
            Object fieldValue = highlight.getValue();
            String targetField = StringUtils.removeEnd((String)fieldName, (String)("_" + language));
            if (!rspContext.getReturnFields().wantsField(targetField)) continue;
            if (this.isMultiValueFiled(schema, targetField)) {
                doc.setField(targetField, fieldValue);
                continue;
            }
            Object firstVal = this.getFirstValue(fieldValue);
            if (firstVal == null) continue;
            doc.setField(targetField, fieldValue);
        }
    }

    private Object getFirstValue(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue.getClass().isArray()) {
            Object[] arr = (Object[])fieldValue;
            if (arr.length > 0) {
                return arr[0];
            }
        } else if (fieldValue instanceof Collection) {
            Collection c = (Collection)fieldValue;
            if (!c.isEmpty()) {
                return c.iterator().next();
            }
        } else {
            return fieldValue;
        }
        return null;
    }

    private boolean isMultiValueFiled(IndexSchema schema, String fieldName) {
        SchemaField fieldOrNull = schema.getFieldOrNull(fieldName);
        return fieldOrNull == null || fieldOrNull.multiValued();
    }

    private Object getFirstValue(SolrDocument doc, SchemaField field) {
        Object value = doc.getFirstValue(field.getName());
        if (value instanceof IndexableField) {
            return DocsStreamer.getValue((SchemaField)field, (IndexableField)((IndexableField)value));
        }
        return value;
    }

    private String buildTypeParam(DocType message, String param) {
        return message.getKey() + "." + param;
    }

    private String buildTypeFilter(DocType type) {
        return "type:" + type.getIndexVal();
    }

    private void appendACLFilter(ModifiableSolrParams query, SolrQueryRequest req, SolrQueryResponse rsp, DocType docType) {
        query.add("fq", new String[]{this.buildACLFilter(req.getParams())});
    }

    private String buildACLFilter(SolrParams params) {
        return QueryHelper.buildTermsQuery("rid", params.getParams("acl[]"));
    }

    private void appendExclusionFilter(ModifiableSolrParams query, SolrQueryRequest req, SolrQueryResponse rsp, DocType docType) {
        String exclMsgFilter;
        String exclRoomFilter;
        SolrParams params = req.getParams();
        if ((docType == DocType.Message || docType == DocType.Room) && StringUtils.isNotBlank((CharSequence)(exclRoomFilter = this.buildExclusionFilter("rid", params.getParams("excl.room[]"))))) {
            query.add("fq", new String[]{exclRoomFilter});
        }
        if (docType == DocType.Message && StringUtils.isNotBlank((CharSequence)(exclMsgFilter = this.buildExclusionFilter("id", params.getParams("excl.msg[]"))))) {
            query.add("fq", new String[]{exclMsgFilter});
        }
    }

    private String buildExclusionFilter(String field, String ... excluded) {
        if (field == null || ArrayUtils.isEmpty((Object[])excluded)) {
            return null;
        }
        return "-" + QueryHelper.buildTermsQuery(field, excluded);
    }

    static class Loggable {
        long numFound;

        Loggable(long numFound) {
            this.numFound = numFound;
        }
    }

    private static interface QueryAdapter {
        public void adaptQuery(ModifiableSolrParams var1, SolrQueryRequest var2, SolrQueryResponse var3, DocType var4);
    }
}

