/*
 * Decompiled with CFR 0.152.
 */
package io.chatpal.solr.ext.handler;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;

public class QueryHelper {
    private QueryHelper() {
    }

    public static String buildTermsQuery(String field, String[] values) {
        if (values == null || values.length < 1) {
            return "-" + field + ":*";
        }
        return String.format("{!terms f=%s}", field) + Arrays.stream(values).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.joining(","));
    }

    public static String buildOrFilter(String field, String[] values) {
        if (values == null || values.length < 1) {
            return "-" + field + ":*";
        }
        return "{!q.op=OR}" + field + ":" + Arrays.stream(values).map(ClientUtils::escapeQueryChars).collect(Collectors.joining(" ", "(", ")"));
    }
}

