/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PersistedResource
extends UnpackedObject
implements DbValue {
    private final StringProperty resourceIdProp = new StringProperty("resourceId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty resourceKeyProp = new LongProperty("resourceKey");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", (DirectBuffer)new UnsafeBuffer());
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty deploymentKeyProp = new LongProperty("deploymentKey", -1L);
    private final StringProperty versionTagProp = new StringProperty("versionTag", "");
    private final StringProperty resourceProp = new StringProperty("resource", "");

    public PersistedResource() {
        super(9);
        this.declareProperty((BaseProperty)this.resourceIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.resourceKeyProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.deploymentKeyProp).declareProperty((BaseProperty)this.versionTagProp).declareProperty((BaseProperty)this.resourceProp);
    }

    public PersistedResource copy() {
        PersistedResource copy = new PersistedResource();
        copy.resourceIdProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getResourceId()));
        copy.versionProp.setValue(this.getVersion());
        copy.resourceKeyProp.setValue(this.getResourceKey());
        copy.checksumProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getChecksum()));
        copy.resourceNameProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getResourceName()));
        copy.tenantIdProp.setValue(this.getTenantId());
        copy.deploymentKeyProp.setValue(this.getDeploymentKey());
        copy.versionTagProp.setValue(this.getVersionTag());
        copy.resourceProp.setValue(this.getResource());
        return copy;
    }

    public DirectBuffer getResourceId() {
        return this.resourceIdProp.getValue();
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public String getVersionTag() {
        return BufferUtil.bufferAsString((DirectBuffer)this.versionTagProp.getValue());
    }

    public long getResourceKey() {
        return this.resourceKeyProp.getValue();
    }

    public DirectBuffer getChecksum() {
        return this.checksumProp.getValue();
    }

    public DirectBuffer getResourceName() {
        return this.resourceNameProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public long getDeploymentKey() {
        return this.deploymentKeyProp.getValue();
    }

    public String getResource() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceProp.getValue());
    }

    public void wrap(ResourceRecord record) {
        this.resourceIdProp.setValue(record.getResourceId());
        this.versionProp.setValue(record.getVersion());
        this.resourceKeyProp.setValue(record.getResourceKey());
        this.checksumProp.setValue(record.getChecksumBuffer());
        this.resourceNameProp.setValue(record.getResourceName());
        this.tenantIdProp.setValue(record.getTenantId());
        this.deploymentKeyProp.setValue(record.getDeploymentKey());
        this.versionTagProp.setValue(record.getVersionTag());
        this.resourceProp.setValue(record.getResourceProp());
    }
}

