/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.user;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.UserState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserIntent;
import io.camunda.zeebe.protocol.record.value.UserType;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public final class DefaultUserCreator
implements StreamProcessorLifecycleAware,
Task {
    public static final String DEFAULT_USER_USERNAME = "demo";
    public static final String DEFAULT_USER_PASSWORD = "demo";
    public static final String DEFAULT_USER_EMAIL = "demo@demo.com";
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final UserState userState;
    private final EngineConfiguration config;
    private final BCryptPasswordEncoder passwordEncoder;

    public DefaultUserCreator(MutableProcessingState processingState, EngineConfiguration config) {
        this.userState = processingState.getUserState();
        this.config = config;
        this.passwordEncoder = new BCryptPasswordEncoder();
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        if (!this.config.isEnableAuthorization()) {
            LOG.debug("Skipping default user creation as authorization is disabled");
            return;
        }
        if (context.getPartitionId() != 1) {
            LOG.debug("Skipping default user creation on partition {} as it is not the deployment partition", (Object)context.getPartitionId());
            return;
        }
        context.getScheduleService().runAtAsync(0L, (Task)this);
    }

    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        Optional.ofNullable(this.userState.getUser("demo")).ifPresentOrElse(user -> LOG.debug("Default user already exists, skipping creation"), () -> {
            UserRecord defaultUser = new UserRecord().setUsername("demo").setName("demo").setEmail(DEFAULT_USER_EMAIL).setPassword(this.passwordEncoder.encode((CharSequence)"demo")).setUserType(UserType.DEFAULT);
            taskResultBuilder.appendCommandRecord((Intent)UserIntent.CREATE, (UnifiedRecordValue)defaultUser);
            LOG.info("Created default user with username '{}' and password '{}'", (Object)"demo", (Object)"demo");
        });
        return taskResultBuilder.build();
    }
}

