/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class ProcessInstanceCommandContext {
    private final MutableElementInstanceState elementInstanceState;
    private TypedRecord<ProcessInstanceRecord> record;
    private ElementInstance elementInstance;
    private final Writers writers;

    public ProcessInstanceCommandContext(MutableElementInstanceState elementInstanceState, Writers writers) {
        this.elementInstanceState = elementInstanceState;
        this.writers = writers;
    }

    public ProcessInstanceIntent getCommand() {
        return (ProcessInstanceIntent)this.record.getIntent();
    }

    public TypedRecord<ProcessInstanceRecord> getRecord() {
        return this.record;
    }

    public void setRecord(TypedRecord<ProcessInstanceRecord> record) {
        this.record = record;
    }

    public ElementInstance getElementInstance() {
        return this.elementInstance;
    }

    public void setElementInstance(ElementInstance elementInstance) {
        this.elementInstance = elementInstance;
    }

    public TypedResponseWriter getResponseWriter() {
        return this.writers.response();
    }

    public MutableElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    public void reject(RejectionType rejectionType, String reason) {
        this.writers.rejection().appendRejection(this.record, rejectionType, reason);
        this.writers.response().writeRejectionOnCommand(this.record, rejectionType, reason);
    }

    public TypedCommandWriter getCommandWriter() {
        return this.writers.command();
    }
}

