/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.metrics.JobProcessingMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.job.JobBatchActivateProcessor;
import io.camunda.zeebe.engine.processing.job.JobCancelProcessor;
import io.camunda.zeebe.engine.processing.job.JobCompleteProcessor;
import io.camunda.zeebe.engine.processing.job.JobFailProcessor;
import io.camunda.zeebe.engine.processing.job.JobRecurProcessor;
import io.camunda.zeebe.engine.processing.job.JobThrowErrorProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeOutProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeoutCheckerScheduler;
import io.camunda.zeebe.engine.processing.job.JobUpdateProcessor;
import io.camunda.zeebe.engine.processing.job.JobUpdateRetriesProcessor;
import io.camunda.zeebe.engine.processing.job.JobUpdateTimeoutProcessor;
import io.camunda.zeebe.engine.processing.job.JobYieldProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import java.time.InstantSource;
import java.util.function.Supplier;

public final class JobEventProcessors {
    public static void addJobProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, Supplier<ScheduledTaskState> scheduledTaskStateFactory, BpmnBehaviors bpmnBehaviors, Writers writers, JobProcessingMetrics jobMetrics, EngineConfiguration config, InstantSource clock) {
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        EventHandle eventHandle = new EventHandle(keyGenerator, processingState.getEventScopeInstanceState(), writers, processingState.getProcessState(), bpmnBehaviors.eventTriggerBehavior(), bpmnBehaviors.stateBehavior());
        JobBackoffChecker jobBackoffChecker = new JobBackoffChecker(clock, scheduledTaskStateFactory.get().getJobState());
        typedRecordProcessors.onCommand(ValueType.JOB, (Intent)JobIntent.COMPLETE, new JobCompleteProcessor(processingState, jobMetrics, eventHandle)).onCommand(ValueType.JOB, (Intent)JobIntent.FAIL, new JobFailProcessor(processingState, writers, processingState.getKeyGenerator(), jobMetrics, jobBackoffChecker, bpmnBehaviors)).onCommand(ValueType.JOB, (Intent)JobIntent.YIELD, new JobYieldProcessor(processingState, bpmnBehaviors, writers)).onCommand(ValueType.JOB, (Intent)JobIntent.THROW_ERROR, new JobThrowErrorProcessor(processingState, bpmnBehaviors.eventPublicationBehavior(), keyGenerator, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.TIME_OUT, new JobTimeOutProcessor(processingState, writers, jobMetrics, bpmnBehaviors.jobActivationBehavior(), clock)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES, new JobUpdateRetriesProcessor(bpmnBehaviors.jobUpdateBehaviour(), writers)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_TIMEOUT, new JobUpdateTimeoutProcessor(bpmnBehaviors.jobUpdateBehaviour(), writers)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE, new JobUpdateProcessor(bpmnBehaviors.jobUpdateBehaviour(), writers)).onCommand(ValueType.JOB, (Intent)JobIntent.CANCEL, new JobCancelProcessor(processingState, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.RECUR_AFTER_BACKOFF, new JobRecurProcessor(processingState, writers, bpmnBehaviors.jobActivationBehavior(), clock)).onCommand(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, new JobBatchActivateProcessor(writers, processingState, processingState.getKeyGenerator(), jobMetrics)).withListener(new JobTimeoutCheckerScheduler(scheduledTaskStateFactory.get().getJobState(), config.getJobsTimeoutCheckerPollingInterval(), config.getJobsTimeoutCheckerBatchLimit(), clock)).withListener(jobBackoffChecker);
    }
}

